#ifndef CALIBRATE_SCREEN_HPP
#define CALIBRATE_SCREEN_HPP

#include "Screen.hpp"
#include "mbed.h"

class CalibrateScreen : public Screen
{
public:
  CalibrateScreen(int *nextScreen, int *ballOnPlate, bool *calStarted, bool *calFinished, int *calPoint, float *calHeldTime);

  void Draw();
  void Process();

private:
  Label _lbTitle;
  Button _btBack;
  Label _lbMessage;

  int *_ballOnPlate;
  int *_calPoint;
  bool *_calStarted;
  bool *_calFinished;
  float *_calHeldTime;
  char _message[50];

  void DisplayMessage();

};
#endif
