#include "CalibrateScreen.hpp"

CalibrateScreen::CalibrateScreen(int *nextScreen, int *ballOnPlate, bool *calStarted, bool *calFinished, int *calPoint, float *calHeldTime) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Calibrate", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _lbMessage( SCREEN_W/2, SCREEN_H/2-10, "Please remove ball from plate", Label::CENTER, Font20)
{
  _nextScreen = nextScreen;
  _ballOnPlate = ballOnPlate;
  _calStarted = calStarted;
  _calHeldTime = calHeldTime;
  _calPoint = calPoint;
  _calFinished = calFinished;
}

void CalibrateScreen::Draw()
{
  Clear();

  _lbTitle.Draw();
  _btBack.Draw();

  DisplayMessage();
}

void CalibrateScreen::Process()
{
  if( _btBack.Touched() )
  {
    *_calFinished = false;
    *_calStarted = false;
    *_calPoint = 0;
    *_nextScreen = MAIN_SETTINGS_SCREEN;
  }

  DisplayMessage();
}

void CalibrateScreen::DisplayMessage()
{
  if( *_calStarted)
  {
    if( *_ballOnPlate )
    {
      float _tempHeldTime = 5;
      _tempHeldTime -= *_calHeldTime;

      if( _tempHeldTime <= 0 )
      {
        sprintf(_message, "Release");
      }
      else
      {
        sprintf(_message, "%.0f", _tempHeldTime);
      }
    }
    else
    {
      sprintf(_message, "Touch and hold position %d", *_calPoint+1);
    }
  }
  else
  {
    if( *_ballOnPlate && !*_calFinished)
    {
      sprintf(_message, "Please remove ball from plate");
    }
    else
    {
      if( *_calFinished )
      {
          sprintf(_message, "Calibration Done");
      }
      else
      {
          *_calStarted = true;
      }
    }
  }

  _lbMessage.Draw(_message);
}
