#include "SquareScreen.hpp"

SquareScreen::SquareScreen( int *nextScreen, float *xSP, float *ySP, int *ballOnPlate, bool *started, float *x, float *y) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "4 Point Pattern", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btReset( SCREEN_W-100, SCREEN_H-30, 100, 30, "Reset"),
  _cSquare( (SCREEN_W/2)-90 ,57, 180,180),
  _btStart( 110, SCREEN_H-30, SCREEN_W-220, 30, "Start"),
  _btStop( 110, SCREEN_H-30, SCREEN_W-220, 30, "Stop"),
  _xMapper((float)((SCREEN_W/2)-90), (float)((SCREEN_W/2)+90), -100, 100),
  _yMapper(57.0, 57.0+180.0, -100, 100)
{
  _nextScreen = nextScreen;
  _xSP = xSP;
  _ySP = ySP;
  _ballOnPlate = ballOnPlate;
  _started = started;
  _x = x;
  _y = y;
  _xPoints[0] = (SCREEN_W/2)-80;
  _yPoints[0] = 67;
  _xPoints[1] = (SCREEN_W/2)-80;
  _yPoints[1] = 47+180;
  _xPoints[2] = (SCREEN_W/2)+70;
  _yPoints[2] = 47+180;
  _xPoints[3] = (SCREEN_W/2)+70;
  _yPoints[3] = 67;
  _currentPoint = 0;
  *_ySP = -_xMapper.Calculate((float)_xPoints[0]);
  *_xSP = -_yMapper.Calculate((float)_yPoints[0]);
}

void SquareScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _cSquare.Draw();
  _btStop.Inactivate();
  _btStart.Inactivate();
  _btStart.Draw();
  _btReset.Draw();
  DrawShape();
}

void SquareScreen::Process()
{
  if( _btBack.Touched() )
  {
    *_started = false;
    *_nextScreen = AUTOMATIC_MORE_SCREEN;
  }

  if( _cSquare.Touched() )
  {
    int _tempX = _cSquare.GetX();
    int _tempY = _cSquare.GetY();
    int _d = 0;
    int _dMin = 999;
    int _index = 0;

    for( int i = 0; i < 4; i ++)
    {
        _d = abs(_tempX-_xPoints[i])+abs(_tempY-_yPoints[i]);

        if( _d < _dMin )
        {
          _index = i;
          _dMin = _d;
        }
    }

    _xPoints[_index] = _tempX;
    _yPoints[_index] = _tempY;
    
    *_ySP = -_xMapper.Calculate((float)_xPoints[_currentPoint]);
    *_xSP = -_yMapper.Calculate((float)_yPoints[_currentPoint]);

    DrawShape();
  }

  if( _btStart.IsActive() )
  {
    if( !*_ballOnPlate )
      _btStart.Inactivate();
    else if( _btStart.Touched() )
    {
      _btStart.Inactivate();
      _btStart.Erase();
      _btStop.Activate();
      _btStop.Draw(0xFFFF0000);
      Thread::wait(200);
      *_started = true;
    }
  }
  else if( _btStop.IsActive() )
  {
    if( _btStop.Touched() )
    {
      _btStop.Inactivate();
      _btStop.Erase();
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
      Thread::wait(200);
      *_started = false;
    }
  }
  else if( *_ballOnPlate )
  {
    if( !_btStop.IsActive() )
    {
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
    }
  }

  if( *_started )
  {
    if( abs(*_x) < 15.0f && abs(*_y) < 15.0f )
    {
        if( _currentPoint < 3 )
            _currentPoint++;
        else
            _currentPoint = 0;
            
        *_ySP = -_xMapper.Calculate((float)_xPoints[_currentPoint]);
        *_xSP = -_yMapper.Calculate((float)_yPoints[_currentPoint]);
    }
    
    DrawShape();
  }
  
  if( _btReset.Touched() )
  {
    _xPoints[0] = (SCREEN_W/2)-80;
  _yPoints[0] = 67;
  _xPoints[1] = (SCREEN_W/2)-80;
  _yPoints[1] = 47+180;
  _xPoints[2] = (SCREEN_W/2)+70;
  _yPoints[2] = 47+180;
  _xPoints[3] = (SCREEN_W/2)+70;
  _yPoints[3] = 67;
  _currentPoint = 0;
  *_ySP = -_xMapper.Calculate((float)_xPoints[0]);
  *_xSP = -_yMapper.Calculate((float)_yPoints[0]);
  DrawShape();
  Thread::wait(200);
  _btReset.Draw();
 }
}

void SquareScreen::DrawShape()
{
  _cSquare.Clear();

  for( int i = 0; i < 4; i++)
  {
    if( i == _currentPoint)
     _cSquare.DrawPoint(_xPoints[i], _yPoints[i], 0xFF00FF00 );
    else
     _cSquare.DrawPoint(_xPoints[i], _yPoints[i] );
  }

  for( int i = 1; i < 4; i++)
  {
    _cSquare.DrawLine(_xPoints[i-1], _yPoints[i-1], _xPoints[i], _yPoints[i]);
  }

  _cSquare.DrawLine(_xPoints[0], _yPoints[0], _xPoints[3], _yPoints[3]);

}
