#include "ManualSetpointScreen.hpp"

ManualSetpointScreen::ManualSetpointScreen(int *nextScreen, float *xSP, float *ySP, int *ballOnPlate, bool *started) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Manual Setpoint", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _tpSetpoint( (SCREEN_W/2)-90 ,57, 180,180, -100.0, 100.0, -100.0 ,100.0),
  _btStart( 110, SCREEN_H-30, SCREEN_W-220, 30, "Start"),
  _btStop( 110, SCREEN_H-30, SCREEN_W-220, 30, "Stop"),
  _btReset( SCREEN_W-100, SCREEN_H-30, 100, 30, "Reset")
{
  _nextScreen = nextScreen;
  _xSP = xSP;
  _ySP = ySP;
  *_xSP = 0;
  *_ySP = 0;
  _ballOnPlate = ballOnPlate;
  _started = started;
}

void ManualSetpointScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _tpSetpoint.Draw();
  _btStop.Inactivate();
  _btStart.Inactivate();
  _btStart.Draw();  
  _btReset.Draw();
}

void ManualSetpointScreen::Process()
{
  if( _btBack.Touched() )
  {
    *_started = false;
    *_nextScreen = AUTOMATIC_MORE_SCREEN;
  }

  if( _tpSetpoint.Touched() )
  {
    _tpSetpoint.Update();

    *_ySP = -floor(_tpSetpoint.GetX());
    *_xSP = -floor(_tpSetpoint.GetY());
  }

  if( _btReset.Touched() )
  {
    _tpSetpoint.Reset();
    _btReset.Draw();

    *_xSP = floor(_tpSetpoint.GetX());
    *_ySP = floor(_tpSetpoint.GetY());
  }

  if( _btStart.IsActive() )
  {
    if( !*_ballOnPlate )
      _btStart.Inactivate();
    else if( _btStart.Touched() )
    {
      _btStart.Inactivate();
      _btStart.Erase();
      _btStop.Activate();
      _btStop.Draw(0xFFFF0000);
      Thread::wait(200);
      *_started = true;
    }
  }
  else if( _btStop.IsActive() )
  {
    if( _btStop.Touched() )
    {
      _btStop.Inactivate();
      _btStop.Erase();
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
      Thread::wait(200);
      *_started = false;
    }
  }
  else if( *_ballOnPlate )
  {
    if( !_btStop.IsActive() )
    {
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
    }
  }

}
