#include "ManualControlScreen.hpp"

ManualControlScreen::ManualControlScreen(int *nextScreen, float *alpha, float *beta) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Manual", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btReset( SCREEN_W-100, SCREEN_H-30, 100, 30, "Reset"),
  _tpManual( (SCREEN_W/2)-104, 29, 208, 208, -10.0,10.0,-10.0,10.0, 5)
{
  _nextScreen = nextScreen;
  _alpha = alpha;
  _beta = beta;
  *_alpha = 0;
  *_beta = 0;
}

void ManualControlScreen::Draw()
{
  Clear(),
  _lbTitle.Draw();
  _btBack.Draw();
  _btReset.Draw();
  _tpManual.Draw();
}

void ManualControlScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = MAIN_MENU_SCREEN;

  if( _btReset.Touched() )
  {
    _tpManual.Reset();
    SetValues();
    Thread::wait(200);
    _btReset.Draw();
  }

  if( _tpManual.Touched() )
  {
    _tpManual.Update();
    SetValues();
    Thread::wait(20);
  }
}

void ManualControlScreen::SetValues()
{
  *_beta = _tpManual.GetX();
  *_alpha = _tpManual.GetY();
}
