#include "MainSettingsScreen.hpp"

MainSettingsScreen::MainSettingsScreen(int *nextScreen) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Settings", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btZeroPlate( 0, 27, ((SCREEN_W)/2)-5, SCREEN_H-67, "Zero Plate", Font20),
  _btCalibrateScreen( (SCREEN_W/2)+5, 27, (SCREEN_W/2)-5, SCREEN_H-67, "Calibrate", Font20)
{
  _nextScreen = nextScreen;
}

void MainSettingsScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btZeroPlate.Draw();
  _btCalibrateScreen.Draw();
}

void MainSettingsScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = MAIN_MENU_SCREEN;


  if( _btZeroPlate.Touched() )
    *_nextScreen = ZERO_PLATE_SCREEN;
    
  if( _btCalibrateScreen.Touched() )
    *_nextScreen = CALIBRATE_SCREEN;
}
