#include "MainMenuScreen.hpp"

MainMenuScreen::MainMenuScreen(int *nextScreen) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Main Menu", Label::CENTER, Font24),
  _btAutomatic( 0, 27,((SCREEN_W)/2)-5, SCREEN_H-67, "Automatic", Font20),
  _btManual( (SCREEN_W/2)+5, 27, (SCREEN_W/2)-5, SCREEN_H-67, "Manual", Font20),
  _btSettings( 0, SCREEN_H-30, SCREEN_W,30, "Settings", Font20)
{
  _nextScreen = nextScreen;
}

void MainMenuScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btAutomatic.Draw();
  _btManual.Draw();
  _btSettings.Draw();
}

void MainMenuScreen::Process()
{
  if( _btSettings.Touched() )
    *_nextScreen = MAIN_SETTINGS_SCREEN;

  if( _btManual.Touched() )
    *_nextScreen = MANUAL_CONTROL_SCREEN;

  if( _btAutomatic.Touched() )
    *_nextScreen = AUTOMATIC_CONTROL_SCREEN;

}
