#include "AutomaticControlScreen.hpp"

AutomaticControlScreen::AutomaticControlScreen(int *nextScreen, float *xPos, float *yPos, int *Ts, bool *started, int *ballOnPlate, float *xSP, float *ySP) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Automatic", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btSettings(SCREEN_W-100, SCREEN_H-30, 100, 30, "Settings"),
  _btStart(0, SCREEN_H-65, SCREEN_W, 30, "Start"),
  _btStop(0, SCREEN_H-65, SCREEN_W, 30, "Stop"),
  _btMore((SCREEN_W/2)-50, SCREEN_H-30, 100, 30, "More"),
  _nlbTs( SCREEN_W/2, 26, "Cycle Time (ms):%d", *Ts, Label::CENTER),
  _gXPos( 0, 40, SCREEN_W/2-1,  158, -170, 170, "X Position (mm)"),
  _gYPos( SCREEN_W/2+1, 40, SCREEN_W/2-1,  158, -136, 136, "Y Position (mm)")
{
  _nextScreen = nextScreen;
  _xPos = xPos;
  _yPos = yPos;
  _Ts = Ts;
  _started = started;
  _xSP = xSP;
  _ySP = ySP;
  _ballOnPlate = ballOnPlate;
}

void AutomaticControlScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btSettings.Draw();
  _btStop.Inactivate();
  _btStart.Inactivate();
  _btStart.Draw();
  _btMore.Draw();
  _nlbTs.Draw();
  _gXPos.Draw();
  _gYPos.Draw();
}

void AutomaticControlScreen::Process()
{
  if( _btBack.Touched() )
  {
    *_started = false;
    *_nextScreen = MAIN_MENU_SCREEN;
  }

  if( _btSettings.Touched() )
  {
    *_nextScreen = AUTOMATIC_SETTINGS_SCREEN;
  }

  if( _btMore.Touched() )
  {
    if( *_started )
    {
      *_started = false;
    }

    *_nextScreen = AUTOMATIC_MORE_SCREEN;
  }


  if( _btStart.IsActive() )
  {
    if( !*_ballOnPlate )
      _btStart.Inactivate();
    else if( _btStart.Touched() )
    {
      _btStart.Inactivate();
      _btStart.Erase();
      _btStop.Activate();
      _btStop.Draw(0xFFFF0000);
      Thread::wait(200);
      *_started = true;
    }
  }
  else if( _btStop.IsActive() )
  {
    if( _btStop.Touched() )
    {
      _btStop.Inactivate();
      _btStop.Erase();
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
      Thread::wait(200);
      *_started = false;
    }
  }
  else if( *_ballOnPlate )
  {
    if( !_btStart.IsActive() )
    {
      _btStart.Activate();
      _btStart.Draw(0xFF00FF00);
    }
  }

  if( *_ballOnPlate && *_started )
  {
    _gXPos.Insert(*_xPos);
    _gYPos.Insert(*_yPos);

    _gXPos.Update();
    _gYPos.Update();

    _nlbTs.Draw("Cycle time (ms):%d",*_Ts);

    if( *_xSP )
    {
      _gXPos.HLine(*_xSP);
    }

    if( *_ySP )
    {
      _gYPos.HLine(*_ySP);
    }

  }
}
