#ifndef SQUARE_SCREEN_HPP
#define SQUARE_SCREEN_HPP

#include "Screen.hpp"
#include "Map.hpp"

class SquareScreen : public Screen
{
public:
  SquareScreen(int *nextScreen, float *xSP, float *ySP, int *ballOnPlate, bool *started, float *x, float *y);

  void Draw();
  void Process();

private:

  void DrawShape();

  Label _lbTitle;
  Button _btBack;
  Button _btReset;
  Canvas _cSquare;
  Button _btStart;
  Button _btStop;


  float *_xSP;
  float *_ySP;
  int *_ballOnPlate;
  bool *_started;
  float *_x;
  float *_y;

  int _xPoints[4];
  int _yPoints[4];

  Map _xMapper;
  Map _yMapper;

  int _currentPoint;
};
#endif
