#include "ChangeValScreen.hpp"

ChangeValScreen::ChangeValScreen(int *nextScreen, int prevScreen, float *valueToChange, string title) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, title, Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btSave( SCREEN_W-100, SCREEN_H-30, 100, 30, "Save"),
  _npValue( 0, 48, SCREEN_W, SCREEN_H-83),
  _nlbValue(SCREEN_W/2, 26, "%.3f", *valueToChange, Label::CENTER, Font20)
{
  _nextScreen = nextScreen;
  _prevScreen = prevScreen;
  _value = valueToChange;
}

void ChangeValScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btSave.Draw();
  _nlbValue.Draw();
  _npValue.Draw();
  _nlbValue.Draw();
}

void ChangeValScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = _prevScreen;

  if( _btSave.Touched() )
  {
    *_value =  _npValue.GetVal();
    *_nextScreen = _prevScreen;
  }

  if( _npValue.Touched() )
  {
    _nlbValue.Draw("%.3f",_npValue.GetVal() );
    Thread::wait(200);
  }

  if( _btSave.Touched() )
  {
    *_value = _npValue.GetVal();
    *_nextScreen = _prevScreen;
  }
}
