#include "AutomaticSettingsScreen.hpp"

AutomaticSettingsScreen::AutomaticSettingsScreen(int *nextScreen, float *P, float *I, float *D, float *Ts) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Settings", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _nlbP(0,26, "P =%.3f", *P, Label::LEFT, Font20),
  _btP(SCREEN_W/2, 26, 100, 30, "Change"),
  _nlbI(0,61, "I =%.3f", *I,  Label::LEFT, Font20),
  _btI(SCREEN_W/2, 61, 100, 30, "Change"),
  _nlbD(0,96, "D =%.3f", *D, Label::LEFT, Font20),
  _btD(SCREEN_W/2, 96, 100, 30, "Change"),
  _nlbTs(0,131, "Ts (ms)=%.0f", *Ts,  Label::LEFT, Font20),
  _btTs(SCREEN_W/2, 131, 100, 30, "Change")
  //TODO Improve layout of this screen
{
  _nextScreen = nextScreen;
  _P = P;
  _I = I;
  _D = D;
  _Ts = Ts;
}

void AutomaticSettingsScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _nlbP.Draw();
  _btP.Draw();
  _nlbI.Draw();
  _btI.Draw();
  _nlbD.Draw();
  _btD.Draw();
  _nlbTs.Draw();
  _btTs.Draw();
}

void AutomaticSettingsScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = AUTOMATIC_CONTROL_SCREEN;

  if( _btP.Touched() )
    *_nextScreen = CHANGE_P_SCREEN;

  if( _btI.Touched() )
    *_nextScreen = CHANGE_I_SCREEN;

  if( _btD.Touched() )
    *_nextScreen = CHANGE_D_SCREEN;

  if (_btTs.Touched() )
    *_nextScreen = CHANGE_TS_SCREEN;
}
