#ifndef AUTOMATIC_CONTROL_SCREEN_HPP
#define AUTOMATIC_CONTROL_SCREEN_HPP

#include "Screen.hpp"

class AutomaticControlScreen : public Screen
{
public:
  AutomaticControlScreen(int *nextScreen, float *xPos, float *yPos, int *Ts, bool *started, int *ballOnPlate, float *xSP, float *ySP);

  void Draw();
  void Process();

private:
  Label _lbTitle;
  Button _btBack;
  Button _btSettings;
  Button _btStart;
  Button _btStop;
  Button _btMore;
  NumericLabel<int> _nlbTs;
  Graph _gXPos;
  Graph _gYPos;


  float *_xPos;
  float *_yPos;
  int *_Ts;
  bool *_started;
  int *_ballOnPlate;
  float *_xSP;
  float *_ySP;
};
#endif
