#ifndef _DUALMOTORCONTROLLER_
#define _DUALMOTORCONTROLLER_

#include "mbed.h"

class DualMotorController {

public:
    DualMotorController(PinName pwmL, PinName dirL0, PinName dirL1, PinName pwmR, PinName dirR0, PinName dirR1, float frequency = 100000.0f);

    void SetLeft(float speed, bool forward);
    void SetRight(float speed, bool forward);

    //TODO : Invert direction
    //TODO : Get current values
    //TODO : Add braking


private:
    PwmOut _pwmL, _pwmR;
    DigitalOut _dirL0, _dirR0;
    DigitalOut _dirL1, _dirR1;

    float _speedL, _speedR;
    bool _inverted;
};
#endif