#include "DualMotorController.hpp"

DualMotorController::DualMotorController(PinName pwmL, PinName dirL0, PinName dirL1, PinName pwmR, PinName dirR0, PinName dirR1, float frequency) :
    _pwmL(pwmL),
    _pwmR(pwmR),
    _dirL0(dirL0,0),
    _dirR0(dirR0,0),
    _dirL1(dirL1,0),
    _dirR1(dirR1,0)
{
    _pwmL.period(1.0f/frequency);
    _pwmR.period(1.0f/frequency);

    _speedL = 0.0f;
    _speedR = 0.0f;
    _inverted = false;
}

void DualMotorController::SetLeft(float speed, bool forward) {
    if( forward ) {
        _dirL0.write(1);
        _dirL1.write(0);
    } else {
        _dirL0.write(0);
        _dirL1.write(1);
    }

    _pwmL.write(speed/100.0f);
}

void DualMotorController::SetRight(float speed, bool forward) {
    if( forward ) {
        _dirR0.write(1);
        _dirR1.write(0);
    } else {
        _dirR0.write(0);
        _dirR1.write(1);
    }

    _pwmR.write(speed/100.0f);
}