#ifndef CYS8218CONTROLLER_H
#define CYS8218CONTROLLER_H

//Includes
#include "mbed.h"

/**
 *  A CYS S8218 servo controller library
 *
 * @author CA Bezuidenhout
 */
class CYS8218Controller
{
public:
  /**
   * @param pwmPin : PWM pin of servo / orange wire
   * @param initAngle : The angle the servo goes to when object is created, when default value (-1) is used, the servo position is not set on object creation.
   */
  CYS8218Controller(PinName pwmPin, float initAngle = -1);

  /**
   * Saves the current position as the zero position.
   */
  void SaveZero();

  /**
   * Sets the zero position without moving the servo
   *
   * @param angle : The angle to set as the zero position
   */
  void SetZero(float angle);

  /**
   * Calibrate the servo
   * @param actualAngle : The actual angle from zero, of the current position in degrees.
   */
  void Calibrate(float actualAngle);

  /**
   * Sets the angular position of the servo
   * @param angle : Desired angle from the zero position in degrees
   */
  void Set(float angle);

  /**
   * Moves to an relative angular position from the current position
   * @param relAngle : The relative angle to move in degrees
   */
  void Move(float relAngle);

  /**
   * Disables control signal to servo
   */
  void Off();


private:
  PwmOut _servo;
  float _angle;
  float _ref;
  float PW_PER_DEG;
  float ZEROPW;

  static const float MIN_PW = 0.0005;
  static const float MAX_PW = 0.0025f;

  void SetServo();
};

#endif
