#include "AS5045Controller.hpp"

AS5045Controller::AS5045Controller(PinName CS) :
  _spi(NC,D12, D13),
  _cs(CS)
{
  _spi.format(9,2);
  _spi.frequency(500000);
  _cs = 1;
}

int AS5045Controller::GetInt()
{
  _cs = 0;
  int upper = _spi.write(0x00);
  int lower = _spi.write(0x00);
  _cs = 1;


  return ((upper << 3)+(lower >> 6));
}

float AS5045Controller::GetFloat()
{
  float value = (float)GetInt();

  return value*0.08789;

}
