#ifndef PID_Dakrory_h
#define PID_Dakrory_h
#define LIBRARY_VERSION 1.0.0

class PID
{


  public:

  
  //commonly used functions **************************************************************************
    PID(float *, float *, float *,        // * constructor.  links the PID to the Input, Output, and 
        float , float , float );     //   Setpoint.  Initial tuning parameters are also set here
    
      void Compute();                       // * performs the PID calculation.  it should be
                                          //   called every time 

    void SetOutputLimits(float , float ); //clamps the output to a specific range. 0-255 by default, but
                                          //it's likely the user will want to change this depending on
                                          //the application
    
void SetIntegratorLimits(float ); 

  //available but not commonly used functions ********************************************************
    void SetTunings(float , float ,       // * While most users will set the tunings once in the 
                    float );              //   constructor, this function gives the user the option
                                          //   of changing tunings during runtime for Adaptive control
                                  //   once it is set                                         
                                          
                                          
  //Display functions ****************************************************************
         
    float kp;                  // * (P)roportional Tuning Parameter
    float ki;                  // * (I)ntegral Tuning Parameter
    float kd;                  // * (D)erivative Tuning Parameter

    
    float *myInput;              // * Pointers to the Input, Output, and Setpoint variables
    float *myOutput;             //   This creates a hard link between the variables and the 
    float *mySetpoint;           //   PID, freeing the user from having to constantly tell us
                                  //   what these values are.  with pointers we'll just know.
              
    
    float ITerm, lasterror;


    float outMin, outMax;
    float max;


};
#endif
