/**********************************************

    Pin map for Olimexino STM32 Board Rev.e

**********************************************/

#include "cmsis.h"
#include "PinNamesTypes.h"

typedef enum {

    // Analogue inputs

    A_0          = PC_0, // D15
    A_1          = PC_1, // D16
    A_2          = PC_2, // D17
    A_3          = PC_3, // D18
    A_4          = PC_4, // D19
    A_5          = PC_5, // D20

    // Digital inputs

    D_0          = PA_3,
    D_1          = PA_2,
    D_2          = PA_0,
    D_3          = PA_1, // Orange LED
    D_4          = PB_5, // default pin 10 of UEXT (Pulled high there)
    D_5          = PB_6, // USART1_TX
    D_6          = PA_8,
    D_7          = PA_9,
    D_8          = PA_10,
    D_9          = PB_7, // USART1_RX
    D_10         = PA_4, // SPI1 SS // optional pin 10 of UEXT (Pulled high there)
    D_11         = PA_7, // SPI1 MOSI // pin 8 of UEXT
    D_12         = PA_6, // SPI1 MISO // pin 7 of UEXT
    D_13         = PA_5, // SPI1 CLK // Green LED // pin 9 of UEXT
    D_14         = PB_8, // CANRX
    D_15         = A0,
    D_16         = A1,
    D_17         = A2,
    D_18         = A3,
    D_19         = A4,
    D_20         = A5,
    D_21         = PC_13, // CAN_CTRL
    D_22         = PC_14, // Osc In  // DO NOT USE
    D_23         = PC_15, // Osc Out // DO NOT USE
    D_24         = PB_9,  // CANTX // pin 2 of Extension
    D_25         = PD_2, // pin 3 of Extension
    D_26         = PC_10, // pin 4 of Extension
    D_27         = PB_0, // VBAT potential divider // DO NOT USE
    D_28         = PB_0, // VBAT potential divider // DO NOT USE
    D_29         = PB_10, // pin 5 of UEXT // pin 7 of Extension // Pulled high
    D_30         = PB_11, // pin 6 of UEXT// pin 8 of Extension // Pulled high
    D_31         = PB_12, // SPI2 SS // pin 9 of Extension
    D_32         = PB_13, // SPI2 CLK // pin 10 of Extension
    D_33         = PB_14, // SPI2 MISO // pin 11 of Extension
    D_34         = PB_15, // SPI2 MOSI // pin 12 of Extension
    D_35         = PC_6, // pin 13 of Extension
    D_36         = PC_7, // pin 14 of Extension
    D_37         = PC_8, // pin 15 of Extension

    // Other stuff

    LED_GREEN   = D_13,
    LED_ORANGE  = D_3,
    BUTTON      = PC_9,

    // CAN

    CAN_CTRL    = D_21,
    CANTX       = D_24,
    CANRX       = D_14,

    // SPI

    SPI1_NSS    = D_10,
    SPI1_MOSI   = D_11, // pin 8 of UEXT
    SPI1_MISO   = D_12, // pin 7 of UEXT
    SPI1_CLK    = D_13, // pin 9 of UEXT

    // UART

    USART1_TX   = D_7, // pin 3 of UEXT
    USART1_RX   = D_8, // pin 4 of UEXT

    USART1_TX_ALT = D_5,
    USART1_RX_ALT = D_9,

    USART2_TX   = D_1,
    USART2_RX   = D_0,

    USART3_TX   = D_29, // pin 7 of Extension // pin 5 of UEXT // Pulled high
    USART3_RX   = D_30, // pin 8 of Extension // pin 6 of UEXT // Pulled high

    USART3_TX_ALT = D_26, // pin 4 of Extension
    USART3_RX_ALT = PC_11, // USB_P // DO NOT USE

} PinsNames;