#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"
#include "beep.h"

Serial serial(USBTX,USBRX);
BMP180 bmp180(p28,p27);              // SDA, SCL
BusOut leds(LED1, LED2, LED3, LED4); // Debug - Error
Beep buzzer(p21);                    // Buzzer Pin
N5110 lcd(p7,p8,p9,p10,p11,p13,p26); // VCC,SCE,RST,D/C,MOSI,SCLK,LED 
InterruptIn unitChanger(p16);        // unit changer button
InterruptIn brightnessButton(p15);   // sleep/brightness button
AnalogIn battery(p17);               // Battrey indicator
DigitalOut led2(p24);                // LED 1
DigitalOut led1(p23);                // LED 2
DigitalOut sce(p8);                  // SCE
SPI spi(p11,NC,p13);                 // SPI
DigitalOut pwr(p7);                  // PWR
DigitalOut dc(p10);                  // DC
PwmOut led(p26);                     // LED

Measurement measurement;             // Store the measurement values
Ticker message;                      // Alert message
Ticker valueReading;  
Ticker interrupt;               // Each 60 sec a reading is taken
LocalFileSystem Local("local");      // Store the data

void celsius(); // Celsius function
void eraseRAM(); // Clear the RAM
void displayOff(); // Turn off the display
void displayOn(); // Turn on the display
void ISR(); // Serial data
void battreyIndicator(float); // Indicate the battrey lfie
void registerTime(); // Time
void setBrightness(float brightness); // Init the brightness
void fahrenheit(); // Fahrenheit function
void dataWrite(float Measurement);// register data
void error(); // indicate error 
void stop();  // stop the opreation
void timeChange(); // intreeupt the time

// Those are flags for the functions
int registerTimeFlag = 0;
int unitChangerFlag = 0;
int celsiusFlag =0;
int brightnessButtonFlag =0;
int setTimeFlag = 0;

char buffer[30]; // creat a charracter
char xString[16]; 


void delayOption() // Calls the Celsius and the Fahrenheit function, however they are delayed by 60 sec
{
    fahrenheit();
    celsius();
    lcd.refresh();
}

void unitChangerProperties() // When the button is pressed value = 0 which changes it to fahrenheit and other way around
{

    if(unitChangerFlag == 1) {
        unitChangerFlag = 0;
        fahrenheit();
    } else { // after the click it returns it to the beggning
        unitChangerFlag = 1;
        celsius();
    }
}

void brightnessSleep() // Gives the button 6 clicks and then return it to the beginning so it can be clicked again
{
    if(brightnessButtonFlag == 6) {
        brightnessButtonFlag = 5;
    } else if (brightnessButtonFlag == 5) {
        brightnessButtonFlag =4;
    } else if (brightnessButtonFlag ==4) {
        brightnessButtonFlag =3;
    } else if (brightnessButtonFlag==3) {
        brightnessButtonFlag=2;
    } else if (brightnessButtonFlag ==2) {
        brightnessButtonFlag =1;
    } else if (brightnessButtonFlag ==1) {
        brightnessButtonFlag =0;
    } else {
        brightnessButtonFlag =6;
    }
}

void buzzerMessage() // When the measurement.temperatureC reaches 27, the following buzz and message will appear
{
    if ( measurement.temperatureC >= 27 ) {
        buzzer.beep(1000,0.3);
        lcd.printString("WARNING!", 15,15);
        lcd.refresh();
    } else {
        lcd.printString("          ", 15,15);
        lcd.refresh();
    }
}

int main()
{
    bmp180.init();        // initialise the sensor
    lcd.init();  // first need to initialise display
    message.attach(&buzzerMessage,0.5); // the message function keep checking every 0.5 seconds
    valueReading.attach(&delayOption, 60.0); // the reading is delayed by 60 second, so every minute the reading will be taken
    battreyIndicator(battery); // call the battrey indicator function
    unitChanger.rise(&unitChangerProperties); // calls the unit changer button function.
    brightnessButton.rise(&brightnessSleep); // calls the sleep/brightness button function.
    delayOption(); // calls the delay function
    lcd.refresh(); // refresh the LCD.

// Section for tempearture
    valueReading.attach(&stop,10.0);  // Read temperature every 10 secondas

    // section for keeping track of time
    serial.attach(&ISR); // attach serial ISR
    valueReading.attach(&stop,300.0);
    set_time(1425386440); // initialise time to current time

    interrupt.attach(&timeChange, 300.0); // print current time every 10.o seconds

    // Section for writing files
    //int counter = 0; // variable to increment

    while(1) {

 stop();
        // section for writing files
       // float temperature = getTemperature();
        dataWrite(measurement.temperatureC); // write current value to disk
        
        
        
        wait(1.0); // small delay
        // Section for time tracking
        if (setTimeFlag) { // if updated time has been sent
            setTimeFlag = 0; // clear flag
            registerTime(); // update time
        }



        if(brightnessButtonFlag == 6) { // starts / and after the last click it return to here and wakes up the screen
            displayOn();
            lcd.setBrightness(0.2);
            lcd.refresh();
        } else if (brightnessButtonFlag == 5) { // the first click increase brightness by 20%
            lcd.setBrightness(0.4);
        } else if (brightnessButtonFlag ==4) {
            lcd.setBrightness(0.6);
        } else if (brightnessButtonFlag==3) {
            lcd.setBrightness(0.8);
        } else if (brightnessButtonFlag==2) {
            lcd.setBrightness (1);
        } else if (brightnessButtonFlag==1) { // Turn off the LCD and put it to sleep, it calls the function which are written below
            displayOff();
            lcd.clear();
            buzzer.nobeep();
            sleep();
        }
    }
}

void celsius() // The function for the Celsius
{
    char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) // so can display a string of a maximum 14 characters in length // or create formatted strings - ensure they aren't more than 14 characters long

    measurement = bmp180.readValues(); // read values (T in Celsius and P in mb) and print over serial port
    //wait(0.1);  // short delau until next reading

    int length = sprintf(buffer,"T = %.2f C",measurement.temperatureC); // print formatted data to buffer // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14)  // if string will fit on display
        lcd.printString(buffer,0,1);           // display on screen

    length = sprintf(buffer,"P = %.2f mb",measurement.pressure);
    if (length <= 14)
        lcd.printString(buffer,0,2);
    lcd.refresh();
}

void fahrenheit() // The function for the fahrenheit
{
    char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) // so can display a string of a maximum 14 characters in length // or create formatted strings - ensure they aren't more than 14 characters long

    measurement = bmp180.readValues(); // read values (T in fahrenheit and P in mb) and print over serial port  //serial.printf("T = %.2f F P = %.2f mb\n",measurement.temperature,measurement.pressure);
    //wait(0.1);  // short delau until next reading

    int length = sprintf(buffer,"T = %.2f F",measurement.temperatureF); // print formatted data to buffer // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14)  // if string will fit on display
        lcd.printString(buffer,0,1);           // display on screen

    length = sprintf(buffer,"P = %.2f mb",measurement.pressure);
    if (length <= 14)
        lcd.printString(buffer,0,2);
    lcd.refresh();
}

void eraseRAM() // Clear the RAM
{
    int i;
    sce.write(0);
    for(i =0; i < 504; i++) {
        spi.write(0x00);
    }

}

void displayOn() // Turn on the display
{
    setBrightness(1.0); // 100%
    pwr.write(1);

}

void displayOff() // Turn off the display
{
    setBrightness(0.0); // 0%
    eraseRAM(); // calls the function

}

void setBrightness(float brightness) // set the brightness
{
    if(brightness < 0.0) {
        brightness = 0.0;
    }
    if (brightness > 1.0) {
        brightness = 1.0;
    }
    led.write(brightness);
}

void battreyIndicator(float voltageIn) // indicate the battrey life
{
    if (voltageIn >=2.5) { // if the voltage equal or larger than 2.5V the green LED will light
        led2 =0;
        led1 =1;
    }
    if (voltageIn <=2.5) { // if the voltage equal or smaller than 2.5V the red LED will light
        led1= 0;
        led2= 1;
    }
}


void ISR()
{
serial.gets(xString,16);
registerTimeFlag = 1;
}
// Writing
void dataWrite(float Measurement)
{

char buffer[30]; // store time 
time_t seconds = time(NULL); // get time
// time and date
strftime(buffer, 30 , "%X %D", localtime(&seconds));

FILE *fp = fopen("/local/log.csv", "a"); // open log
// Create file
fprintf(fp,"%f,%s\n",measurement.temperatureC, buffer); // print string to file
fclose(fp); // Close it
}

// Incase of error
void error(int code)
{
while(1) {
leds = 0;
wait(0.25);
leds = code;
wait(0.25);
}
}

//  register Temperature
void stop()
{
serial.printf("T = %f C\n",measurement.temperatureC); // Show temp value
dataWrite(measurement.temperatureC); // write temp value
}

void registerTime()
{
// register the time for debugging purposes
serial.printf("set_time - %s",xString);
// String -> integer
int time = atoi(xString);
set_time(time);
}

// Time
void timeChange()
{
char buffer[30]; // store time 
time_t seconds = time(NULL); // get current time
// format to string
strftime(buffer, 30 , "%X %D", localtime(&seconds));
// serial
serial.printf("Time = %s\n",buffer);
}