#include "mbed.h"

SPI spi(p5,p6,p7);
DigitalOut cs(p8);
InterruptIn Max3140Data(p9);

Serial pc(USBTX, USBRX);

int ret = 0;
char input_character = 0;
char output_character = 0;
char input_buffer[16384];
int input_buffer_pointer = 0;
int output_buffer_pointer = 0;

void gotit() {

   cs = 0;  
   ret = 0;
   ret = spi.write(0x0000);
   cs = 1;
   input_character = char(ret & 0x7F);
   input_buffer[input_buffer_pointer++] = input_character;
   //pc.printf("%c",input_character);
}

void Max3140_Write(char output_byte){
    ret = 0;
    cs = 0;
    ret = spi.write(0x8000 | output_byte);
    cs = 1;
    wait(0.0001);
    }
    

int main(){ 

    spi.format(16,0);
    spi.frequency(1000000);

    Max3140Data.mode(PullUp);    
    Max3140Data.fall(&gotit);

    wait(0.5);
    
    Max3140_Write('H');
    Max3140_Write('e');
    Max3140_Write('l');
    Max3140_Write('l');
    Max3140_Write('o');
    Max3140_Write('\r');
    Max3140_Write('\n');    
    
    ret = 0;
    cs = 0;
    ret = spi.write(0xC400);
    cs = 1;
    wait(0.1);
    //pc.printf("\r\nWRITE CONFIGURATION register = 0x%04X\r\n ", ret);

    cs = 0;
    ret = spi.write(0x4000);
    cs = 1;
    //pc.printf("\r\nREAD CONFIGURATION register = 0x%04X\r\n", ret);
    wait(0.1);

    // Try to read some data

    ret = 0;
    cs = 0;
    ret = spi.write(0x8600);
    cs = 1;
    
    wait(0.1);
    
     //cs = 0;
    //ret = spi.write(0x0000);
    // cs = 1;
    
    pc.printf("at loop\r\n");
    input_buffer_pointer = output_buffer_pointer = 0; 
    for(;;){       
        if(input_buffer_pointer > output_buffer_pointer){
            //pc.printf("%d %d\r\n", input_buffer_pointer, output_buffer_pointer);
            output_character = input_buffer[output_buffer_pointer++];
            pc.printf("%c", output_character);
        }
    }
 
}