#include "mbed.h"
#include "motordriver.h"
 
Serial pc(USBTX, USBRX);
Serial device(p9, p10); //Connect JY-MCU bluetooth module to 9,10
 
Motor  right(p21, p22, p23, 1); // pwm, fwd, rev, has brake feature
Motor left(p26, p25, p24, 1);
float speed;
 
int main()
{
    unsigned char Instr;//What button was sent? 1 = forward, 2 = backward
    unsigned char sentSpeed; //What is the slider set to? 
    device.baud(57600);
    while(1) {
 
 
        if(device.readable()) {
            Instr = device.getc();
            pc.printf("Instruction: %i\n\r", Instr);
            wait(.05);//Wait for the next bluetooth value to be recieved. 
           if(device.readable()){
                    sentSpeed = device.getc();
                    switch (Instr){
                    case 0://Stop
                    left.speed(0);
                    right.speed(0);
                    break;
                    case 1://Forward
                    pc.printf("Speed: %i\n\r", sentSpeed);
                    speed = float(sentSpeed) / 100;
                    left.speed(speed);
                    right.speed(speed);
                    break;
                    case 2://Reverse
                    pc.printf("Reverse speed: %i\n\r", sentSpeed);
                    speed = -float(sentSpeed) / 100;
                    left.speed(speed);
                    right.speed(speed);
                    break;
                    case 3://Clockwise Turn
                    speed = float(sentSpeed) / 100;
                    left.speed(speed);
                    right.speed(-speed);
                    break;
                    case 4://CCW Turn
                    speed = float(sentSpeed) / 100;
                    left.speed(-speed);
                    right.speed(speed);
                    break;
                    }//End Switch

                }//End Speed Read
            }//End Instruction Read
        
        
    }
}