#include "mbed.h"

DigitalOut myled(LED1);
bool ledState = false;
HAL_StatusTypeDef FLASHStatus;
Serial pc(SERIAL_TX, SERIAL_RX);
  
HAL_StatusTypeDef writeEEPROMByte(uint32_t address, uint8_t data)
 {
    HAL_StatusTypeDef  status;
    address = address + 0x08080000;
    HAL_FLASHEx_DATAEEPROM_Unlock();  //Unprotect the EEPROM to allow writing
    status = HAL_FLASHEx_DATAEEPROM_Program(TYPEPROGRAMDATA_BYTE, address, data);
    HAL_FLASHEx_DATAEEPROM_Lock();  // Reprotect the EEPROM
    return status;
}
  
//HAL_StatusTypeDef writeEEPROMByte(uint32_t address, uint8_t data) {
//    HAL_StatusTypeDef status = FLASH_COMPLETE;
//    address = address + 0x08080000;
//    DATA_EEPROM_Unlock();  //Unprotect the EEPROM to allow writing
//    status = DATA_EEPROM_ProgramByte(address, data);
//    DATA_EEPROM_Lock();  // Reprotect the EEPROM
//    return status;
//}
 
uint8_t readEEPROMByte(uint32_t address) {
    uint8_t tmp = 0;
    address = address + 0x08080000;
    tmp = *(__IO uint32_t*)address;
    
    return tmp;
}
 
 
int main() {
    //while(1) {
        pc.printf("Attempting to write to EEPROM...");
        for (uint32_t i = 0; i < 256; i++) {
            FLASHStatus = writeEEPROMByte(i, (uint8_t)i);
            }
        //if(FLASHStatus == FLASH_COMPLETE)
        if(1==1) 
            {pc.printf("Success!!\r\n");}
        else
            {pc.printf("Failed!!\r\n");}
           
        for (uint32_t i = 0; i < 256; i++) {    
            uint8_t storedValue = readEEPROMByte(i);
            pc.printf("Stored value: %d \n\r", storedValue);
            }
            
        //Flash LED to let us know something is happening
        ledState= !ledState;
        myled = ledState; 
        wait(1.0); // Wait a bit so we're not hammering the EEPROM
    //}
}



/*
#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn mybutton(USER_BUTTON);

double tempo = 0.3; // LED blinking delay

// Change LEDs blinking frequency
void change_blinking_frequency() {
    if (tempo == 0.3) // If leds have low frequency
        tempo = 0.1;  // Set the fast frequency
    else              // If leds have fast frequency
        tempo = 0.3;  // Set the low frequency
}

HAL_StatusTypeDef writeEEPROMByte(uint32_t address, uint8_t data)
 {
    HAL_StatusTypeDef  status;
    address = address + 0x08080000;
    HAL_FLASHEx_DATAEEPROM_Unlock();  //Unprotect the EEPROM to allow writing
    status = HAL_FLASHEx_DATAEEPROM_Program(TYPEPROGRAMDATA_BYTE, address, data);
    HAL_FLASHEx_DATAEEPROM_Lock();  // Reprotect the EEPROM
    return status;
}

int main() {
    // All LEDs are OFF
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;

    // Change LEDs blinking frequency when button is pressed
    mybutton.fall(&change_blinking_frequency);

    while(1) {
        myled2 = 1;   // LED2 is ON
        wait(tempo);  // wait tempo
        myled2 = 0;   // LED2 is OFF
        myled1 = 1;   // LED1 is ON
        wait(tempo);  // wait tempo
        myled1 = 0;   // LED1 is OFF
        myled3 = 1;   // LED3 is ON
        wait(tempo);  // wait tempo
        myled3 = 0;   // LED3 is OFF
        myled4 = 1;   // LED4 is ON
        wait(tempo);  // wait tempo
        myled4 = 0;   // LED4 is OFF
    }
}

*/