#include "DDBooster.h"

#define LEDS 20

int main()
{
    // get the instance of DDBooster with configured SPI pins
    DDBooster booster(SPI_MOSI, SPI_SCK, SPI_CS);
    
    // tell the number of LEDs used
    booster.init(LEDS);

    // we start outside from -8 to 0. first led has always index 0
    // both values define the length of the drop
    int16_t start = -8, end = 0;
    // show a gradient from white to blue
    uint8_t startColor[] = {60, 60, 60};
    uint8_t endColor[] = {0, 0, 60};

    while(1) {
        // turn all leds off
        booster.clearAll();
        // set gradient with current values
        booster.setGradient(start, end, startColor, endColor);
        // commit it
        booster.show();

        // when the start index runs out of visible area (last led has index led_count - 1)
        // start from the beginning, otherwise increment the start and end postitions
        if (start == LEDS) {
            start = -8;
            end = 0;
            // delay between the drops
            wait_ms(1000);
        } else {
            start++;
            end++;
        }

        // changing the value makes the drop fall faster or slower
        wait_ms(20);
    }
}