#include "mbed.h"
#include "BLE.h"
#include "UARTService.h"
#include "DDBooster.h"

const static char DEVICE_NAME[] = "DD-Booster";

#define SPI_MOSI P0_3
#define SPI_SCK P0_4
#define SPI_CS P0_2
#define RESET P0_1

UARTService *uart = NULL;
DDBooster booster(SPI_MOSI, SPI_SCK, SPI_CS, RESET);

void onConnected(const Gap::ConnectionCallbackParams_t *params)
{
    Gap::ConnectionParams_t fast;
    BLE &ble = BLE::Instance();

    ble.getPreferredConnectionParams(&fast);
    fast.minConnectionInterval = 8;
    fast.maxConnectionInterval = 16;
    fast.slaveLatency = 0;
    ble.setPreferredConnectionParams(&fast);
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE &ble = BLE::Instance();
    ble.startAdvertising();
}

void onDataWritten(const GattWriteCallbackParams *params)
{
    if ((uart != NULL) && (params->handle == uart->getTXCharacteristicHandle())) {
        booster.sendRawBytes(params->data, params->len);
    }
}


int main(void)
{
    booster.reset();

    BLE &ble = BLE::Instance();
    ble.init();
    ble.onConnection(onConnected);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);

    uart = new UARTService(ble);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (const uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME) - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(500);
    ble.startAdvertising();

    while (true) {
        ble.waitForEvent();
    }
}
