#ifndef _NICROM_HPP_
#define _NICROM_HPP_

/**
    @author Gaku MATSUMOTO
    @bref   ニクロム線に電流を流したり流さなかったりするライブラリです．
    @note   オブジェクト指向の真似事としてクラスにしてみました．
*/
class Nicrom{
    public:
        /**
        *  @bref  ニクロム線クラスのインスタンス
        *  @param  _pin  ニクロム線に電流を流すトリガーとなるピン番号
        */
        Nicrom(PinName _pin);
    private:
        Timeout stopTimer;
        Nicrom* _nic;
        DigitalOut _nicrom;  
        PinName pinBango;
    public:
        int status;
        void fire();
        void stop();
        void autoStop(float t);
};

Nicrom::Nicrom(PinName _pin) : _nicrom(_pin){
    _nic = this;
    pinBango = _pin;
    _nicrom = 0;
    status = 0;
}

/**
    @bref   ニクロム線を通電します．
    @note   当然ですが，あくまでトリガーとして利用してください．
*/
void Nicrom::fire(){
    _nicrom = 1;
    status = 1;   
    printf("fire\r\n");
}

/**
    @bref   ニクロム線の電流を止めます．
    @note   MOSFETの種類によっては漏れ電流などで少し流れる場合があります．
*/
void Nicrom::stop(){
    _nicrom = 0;
    status = 0;   
    printf("stop\r\n");
}
 
/**
    @bref   指定した時間だけ，電流を流し，時間が来たら止めます．
    @note   連続で何度も実行しないようにお願いします．
*/
void Nicrom::autoStop(float t){
    fire();
    stopTimer.attach(_nic, &Nicrom::stop, t);     
}
#endif