/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "TestAccelerometer.hpp"
#include "Accelerometer.hpp"
#include "Utility.hpp"
#include "mbed.h"

#include <cassert>
#include <cmath>

namespace accelerometer
{
    void run_all_tests()
    {
        test_raw_axis_data_to_int();
        test_set_standby_and_active();
        test_g_force_from_int_axis_data();
        test_angle_from_int_axis_data();
    }
    
    void test_raw_axis_data_to_int()
    {    
        assert(128 == (unsigned char)(0x80));
        assert(-128 == (signed char)(0x80));
        
        assert(0 == raw_axis_data_to_int(0x00));
        assert(1 == raw_axis_data_to_int(0x01));
        assert(127 == raw_axis_data_to_int(0x7F));
        assert(-1 == raw_axis_data_to_int(0xFF));
        assert(-128 == raw_axis_data_to_int(0x80));
    }
    
    void test_set_standby_and_active()
    {
        Accelerometer accelerometer(p9, p10, I2C_ACCELEROMETER_ADDRESS);
    
        accelerometer.set_standby();
        char value = accelerometer.read_register(CTRL_REG1_REGISTER_ADDRESS);
        if(value % 2 != 0)
        {
            printf("Fail\r\n");
        }
    
        accelerometer.set_active();
        value = accelerometer.read_register(CTRL_REG1_REGISTER_ADDRESS);
        if(value % 2 != 1)
        {
            printf("Fail\r\n");
        }
    }
    
    //axis_data = 64 means 1 g
    void test_angle_from_int_axis_data()
    {
        const double tolerance = 0.05;
        assert(utility::is_almost_equal(0, angle_from_int_axis_data(64), tolerance));
        assert(utility::is_almost_equal(0, angle_from_int_axis_data(-64), tolerance));
        assert(utility::is_almost_equal(60, angle_from_int_axis_data(32), tolerance));
        assert(utility::is_almost_equal(60, angle_from_int_axis_data(-32), tolerance));
    }
    
    void test_angle_from_int_axis_data_when_above_1g_is_corrected_to_zero()
    {
        const double tolerance = 0.05;
        const double axis_data_above_1g = 65;
        assert(utility::is_almost_equal(0, angle_from_int_axis_data(axis_data_above_1g), tolerance));
    }
    
    void test_g_force_from_int_axis_data()
    {
        const double tolerance = 0.05;
        assert(utility::is_almost_equal(1, g_force_from_int_axis_data(64), tolerance));
        assert(utility::is_almost_equal(-1, g_force_from_int_axis_data(-64), tolerance));
        assert(utility::is_almost_equal(2, g_force_from_int_axis_data(128), tolerance));
        assert(utility::is_almost_equal(-2, g_force_from_int_axis_data(-128), tolerance));
        assert(utility::is_almost_equal(0.5, g_force_from_int_axis_data(32), tolerance));
        assert(utility::is_almost_equal(-0.5, g_force_from_int_axis_data(-32), tolerance));
    }
}