/////////////////////////////////////////////////////////////a
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

//aha je vais faire un pull request!
#include "mbed.h"
#include "Accelerometer.hpp"
#include "TestAccelerometer.hpp"
#include "TestUtility.hpp"
#include "TestHomemadeMbed.hpp"
#include "SPIDisplayer.hpp"
#include "UARTDisplayer.hpp"
#include "HomemadeMbed.hpp"
#include "Utility.hpp"

#include <cassert>

void testSPIDisplayer()
{
    printf("Manual test.\r\nDisplay should show \"10.00\",  \"00.00\", \"01.54\", \"12.12\".\r\n");
    SPIDisplayer spiDisplayer(p5, NC, p7, p8);
    spiDisplayer.reset();
    spiDisplayer.displayAngle(10);
    wait(1);
    spiDisplayer.displayAngle(0);
    wait(1);
    spiDisplayer.displayAngle(1.54321);
    wait(1);
    spiDisplayer.displayAngle(12.1234);
    wait(1);
}

void run_manual_tests()
{
    testSPIDisplayer();
}

void run_automatic_tests()
{
    homemade_mbed::run_all_tests();
    accelerometer::run_all_tests();
    utility::run_all_tests();
    printf("All automatic tests pass\r\n");
}

int main()
{
    run_automatic_tests();
    
    accelerometer::Accelerometer accelerometer(p9, p10, 5);
    accelerometer.init();
    
    SPIDisplayer displayer(p5, NC, p7, p8);
    //UARTDisplayer displayer;
    displayer.reset();

    while(true)
    {
        const double angle_from_horizontal = accelerometer.get_angle_from_horizontal();
        displayer.displayAngle((float) angle_from_horizontal);
        wait(0.1);
    }
}