/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "TestHomemadeMbed.hpp"
#include "Utility.hpp"
#include "HomemadeMbed.hpp"

#include <cassert>
#include <cstdio>

namespace homemade_mbed
{
    void run_all_tests()
    {
        test_read_bits();
        test_write_bits();
        test_get_reserved_bits_mask();
    }
    
    void test_read_bits()
    {
        //CLKOUTCFG - 0x400F C1C8
        //Bits 0-9 all have a reset value of 0
        assert(0x00 == read_bits(reinterpret_cast<unsigned int*>(0x400FC1C8), 0, 9));
        
        //PCONP - address 0x400F C0C4
        //Bits 1,2,3,4 all have a reset value of 1
        assert(0x0F == read_bits(reinterpret_cast<unsigned int*>(0x400FC0C4), 1, 4));
    }
    
    void test_write_bits()
    {
        //CLKOUTCFG - 0x400F C1C8
        //Bits 0-9 all have a reset value of 0
        assert(0x00 == read_bits(reinterpret_cast<unsigned int*>(0x400FC1C8), 0, 9));
        
        write_bits(reinterpret_cast<unsigned int*>(0x400FC1C8), 4, 7, 0x0F);
        
        assert(0x0F == read_bits(reinterpret_cast<unsigned int*>(0x400FC1C8), 4, 7));
        write_bits(reinterpret_cast<unsigned int*>(0x400FC1C8), 4, 7, 0x00);
    }
    
    void test_get_reserved_bits_mask()
    {
        assert(0x000003FF == get_reserved_bits_mask(reinterpret_cast<unsigned int*>(0x400FC1C8)));
    }
}