/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#ifndef UTILITY_HPP
#define UTILITY_HPP
#include <list>

namespace utility
{
    const double PI = 3.14159265;    

    bool is_almost_equal(double a, double b, double tolerance);

    //Return angle between 0 and 360 degree
    double wrap_angle(double angle);
    double degree_from_radian(const double angle_radian);
    
    //Calculate the 4 bytes required to represent a previous 4 bytes value
    //after changing a single bit at a given position (position 0 being the LSB)
    unsigned int update_bit(const unsigned int previous_4_bytes, const int position, const bool new_bit_value);
    
    unsigned int update_bits(const unsigned int previous_4_bytes, const int start_bit, const int stop_bit, const unsigned int reserved_bits_mask, const unsigned int new_bits_value);
    //Hang the program and blink an LED on the mbed
    void blink();
    
    class MovingAverageFilter
    {
        public:
            MovingAverageFilter(const int subSize);
            int calculate(int newValue);
            
        private:
            const int subsetSize;
            std::list<int> subset;
    };
}

#endif