/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "UARTDisplayer.hpp"
#include <cstdio>
#include "Utility.hpp"
#include "HomemadeMbed.hpp"
#include "mbed.h" //Needed for function wait
#include <cassert>

UARTDisplayer::UARTDisplayer()
{
    this->device.init();
}

void UARTDisplayer::displayAngle(float angle)
{
    char digits[6];
    std::snprintf(digits, sizeof digits, "%f", angle);
    
    if(digits[1] == '.')
    {
        device.write(0);
        device.write((int)digits[0] - 48);
        device.write((int)digits[2] - 48);
        device.write((int)digits[3] - 48);
    }
    else
    {
        device.write((int)digits[0] - 48);
        device.write((int)digits[1] - 48);
        device.write((int)digits[3] - 48);
        device.write((int)digits[4] - 48);
    }
    
    device.write(DECIMAL_CONTROL_REGISTER);
    device.write(FLOATING_POINT_DOT_POSITION);
}

void UARTDisplayer::reset()
{
    device.write(CLEAR_DISPLAY_REGISTER);
    device.write(CURSOR_CONROL_REGISTER);
    device.write(MOST_LEFT_DIGIT_POSITION);
}

void HomemadeUART::write(const unsigned char value)
{
    //UART1 Transmitter Holding Register
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x40010000), 0, 7, value);
}

void HomemadeUART::init()
{
    //Power: In the PCONP register (Table 46), set bits PCUART1
    //Default: enabled
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x400FC0C4), 4, 4, 0x01);
    
    //Peripheral clock: In the PCLKSEL0 register (Table 40), select PCLK_UART1
    //Default: PCLK_peripheral = CCLK/4
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x400FC1A8), 8, 9, 0x00);
        
    set_lcr();
    set_baud_rate(9600);
    set_fifo();
    
    //Pins: Select UART pins through PINSEL registers
    //Pin Function Select Register 1 (TXD1)
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x4002C000), 30, 31, 0x01);
}

void HomemadeUART::set_baud_rate(const unsigned int baud_rate)
{
    const unsigned int m = homemade_mbed::read_bits(reinterpret_cast<unsigned int*>(0x400FC088), 0, 14) + 1;
    const unsigned int n = homemade_mbed::read_bits(reinterpret_cast<unsigned int*>(0x400FC088), 16, 23) + 1;
    const unsigned int in_frequency = 4000000; //Hz
    const unsigned int fcco = (2 * m * in_frequency) / n;
    const unsigned int x = fcco / (baud_rate * 16 * 4);

    //Baud rate: In register U1LCR (Table 298), set bit DLAB =1
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x4001000C), 7, 7, 0x01);
    //Set the baud rate
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x40010000), 0, 7, x); //UART1 Divisor Latch LSB Register (U1DLL
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x40010004), 0, 7, 0x00); //UART1 Divisor Latch MSB Register (U1DLM)
    //Baud rate: In register U1LCR (Table 298), set bit DLAB =0
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x4001000C), 7, 7, 0x00);
}

void HomemadeUART::set_fifo()
{
    //UART FIFO: Use bit FIFO enable (bit 0) in register U0FCR (Table 297) to enable FIFO
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x40010008), 0, 0, 0x01);
}

void HomemadeUART::set_lcr()
{
    homemade_mbed::write_bits(reinterpret_cast<unsigned int*>(0x4001000C), 0, 1, 0x03);
}