/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "TestUtility.hpp"
#include "Utility.hpp"

#include <cassert>

namespace utility
{
    void run_all_tests()
    {
        test_is_almost_equal();
        test_degree_from_radian();
        test_wrap_angle();
        test_update_bit();
        test_update_bit_for_values_greater_than_one_byte();
        test_update_bits();
        test_moving_average_filter();
    }
    
    void test_is_almost_equal()
    {
        assert(is_almost_equal(0, 0, 0.01));
        assert(is_almost_equal(0.50, 0.51, 0.02));
        assert(!is_almost_equal(0.50, 0.52, 0.01));
        assert(!is_almost_equal(0, 0.50, 0.1));
    }
    
    void test_degree_from_radian()
    {
        const double tolerance = 0.05;
        assert(is_almost_equal(0, degree_from_radian(0.0), tolerance));
        assert(is_almost_equal(90, degree_from_radian(PI/2.0), tolerance));
        assert(is_almost_equal(180, degree_from_radian(PI), tolerance));
        assert(is_almost_equal(270, degree_from_radian(3.0*PI/2.0), tolerance));
        assert(is_almost_equal(0, degree_from_radian(2.0*PI), tolerance) || is_almost_equal(360, degree_from_radian(2.0*PI), tolerance));
        assert(is_almost_equal(270, degree_from_radian(-PI/2.0), tolerance));
    }
    
    void test_wrap_angle()
    {
        const double tolerance = 0.05;
        assert(is_almost_equal(0, wrap_angle(0.0), tolerance));
        assert(is_almost_equal(90, wrap_angle(90), tolerance));
        assert(is_almost_equal(180, wrap_angle(180), tolerance));
        assert(is_almost_equal(0, wrap_angle(360), tolerance) || is_almost_equal(360, wrap_angle(360), tolerance));
        assert(is_almost_equal(90, wrap_angle(360+90), tolerance));
        assert(is_almost_equal(270, wrap_angle(360-90), tolerance));
    }
    
    void test_update_bit()
    {
        assert(4 == sizeof(int));
        assert(0x00 == update_bit(0x00, 0, 0));
        assert(0x01 == update_bit(0x00, 0, 1));
        assert(0x00 == update_bit(0x01, 0, 0));
        assert(0x05 == update_bit(0x07, 1, 0));
    }
    
    void test_update_bit_for_values_greater_than_one_byte()
    {
        assert(0x7FFF == update_bit(0xFFFF, 15, 0));
        assert(0x7FFFFFFF == update_bit(0xFFFFFFFF, 31, 0));
    }
    
    void test_update_bits()
    {
        assert(0x0F == update_bits(0x00, 0, 3, 0xFFFFFFFF, 0x0F));
        assert(0x1E == update_bits(0x00, 1, 4, 0xFFFFFFFF, 0x0F));
        assert(0x00 == update_bits(0x00, 0, 3, 0x00000000, 0x0F));
        assert(0x00 == update_bits(0x00, 1, 4, 0x00000000, 0x0F));
    }
    
    void test_moving_average_filter()
    {
        MovingAverageFilter filter(5);
        assert(1 == filter.calculate(5));
        assert(2 == filter.calculate(5));
        assert(3 == filter.calculate(5));
        assert(4 == filter.calculate(5));
        assert(5 == filter.calculate(5));
    }
}