/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "SPIDisplayer.hpp"

SPIDisplayer::SPIDisplayer(PinName mosi, PinName miso, PinName sclk, PinName ssel):
    device(SPI(mosi, miso, sclk, ssel)),
    pc(Serial(USBTX, USBRX))
{
   
}

void SPIDisplayer::displayAngle(float angle)
{
    char digits[6];
    snprintf(digits, sizeof digits, "%f", angle);
    
    if(digits[1] == '.')
    {
        device.write(0);
        wait(0.001);
        device.write((int)digits[0] - 48);
        wait(0.001);
        device.write((int)digits[2] - 48);
        wait(0.001);
        device.write((int)digits[3] - 48);
        wait(0.001);
    }
    else
    {
        device.write((int)digits[0] - 48);
        wait(0.001);
        device.write((int)digits[1] - 48);
        wait(0.001);
        device.write((int)digits[3] - 48);
        wait(0.001);
        device.write((int)digits[4] - 48);
        wait(0.001);
    }
    
    device.write(DECIMAL_CONTROL_REGISTER);
    wait(0.001);
    device.write(FLOATING_POINT_DOT_POSITION);
    wait(0.001);
}

void SPIDisplayer::reset()
{
    device.write(CLEAR_DISPLAY_REGISTER);
    wait(0.001);
    device.write(CURSOR_CONROL_REGISTER);
    wait(0.001);
    device.write(MOST_LEFT_DIGIT_POSITION);
    wait(0.001);
}