/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#include "HomemadeMbed.hpp"
#include "Utility.hpp"
#include <cassert>
#include "mbed.h"

namespace homemade_mbed
{
    unsigned int read_bits(unsigned int* address_4_bytes, const int start_bit, const int stop_bit)
    {
        const unsigned int all_4_bytes = *address_4_bytes;
        const unsigned int left_shifted = all_4_bytes << (31 - stop_bit);
        const unsigned int right_shifted = left_shifted >> (31 - stop_bit + start_bit);
        return right_shifted;
    }
    
    void write_bits(unsigned int* address_4_bytes, const int start_bit, const int stop_bit, const unsigned int new_value)
    {
        const unsigned int all_4_bytes = *address_4_bytes;
        const unsigned int reserved_bits_mask = get_reserved_bits_mask(address_4_bytes);
        const unsigned int new_bits = utility::update_bits(all_4_bytes, start_bit, stop_bit, reserved_bits_mask, new_value);
        *address_4_bytes = new_bits;
        
        assert(new_value == homemade_mbed::read_bits(address_4_bytes, start_bit, stop_bit));
    }
    
    unsigned int get_reserved_bits_mask(unsigned int* address_4_bytes)
    {
        switch((unsigned int)address_4_bytes)
        {
            case 0x400FC1C8: return 0x000003FF;
            case 0x400FC0C4: return 0xEFEFF7DE;
            case 0x4000C000: return 0x000000FF;
            case 0x40098000: return 0x000000FF;
            case 0x4009C000: return 0x000000FF;
            case 0x4009800C: return 0x000000FF;
            case 0x4009C00C: return 0x000000FF;
            case 0x4000C00C: return 0x000000FF;
            case 0x400FC088: return 0x07FF7FFF;
            case 0x4000C008: return 0x000003CF;
            case 0x40098008: return 0x000003CF;
            case 0x4007C008: return 0x000000CF;
            case 0x4001000C: return 0x000000FF;
            case 0x40010000: return 0x000000FF;
            case 0x40010004: return 0x000000FF;
            case 0x400FC1A8: return 0xFFF3F3FF;
            case 0x40010008: return 0x000000CF;
            case 0x4002C000: return 0xFFFFFFFF;
            default: break; //Unknown address. Should never happen
        }
        
        //Crash
        printf("Unknown address: %d\r\n", (unsigned int)address_4_bytes);
        utility::blink();
        return 0x00000000;
    }
}