/////////////////////////////////////////////////////////////
// APP 1: Systèmes à microprocesseurs                      //
//                                                         //
// Université de Sherbrooke                                //
// Génie informatique                                      //
// Session 5, Hiver 2017                                   //
//                                                         //
// Date:    17 janvier 2017                                //
//                                                         //
// Auteurs: Maxime Dupuis,       dupm2216                  //
//          Bruno Allaire-Lemay, allb2701                  //
/////////////////////////////////////////////////////////////

#ifndef ACCELEROMETER_HPP
#define ACCELEROMETER_HPP

#include "mbed.h"
#include "Utility.hpp"

namespace accelerometer
{
    const int NUMBER_OF_DATA_REGISTERS = 6;
    const char OUT_X_MSB_REGISTER = 0x01;
    const char OUT_X_LSB_REGISTER = 0x02;
    const char OUT_Y_MSB_REGISTER = 0x03;
    const char OUT_Y_LSB_REGISTER = 0x04;
    const char OUT_Z_MSB_REGISTER = 0x05;
    const char OUT_Z_LSB_REGISTER = 0x06;
    
    const char WHO_AM_I_REGISTER = 0x0D;
    const char CTRL_REG1_REGISTER_ADDRESS = 0x2A;
    
    const int I2C_ACCELEROMETER_ADDRESS = 0x1D;
    
    enum Axis
    {
        AXIS_X,
        AXIS_Y,
        AXIS_Z,
        AXIS_INVALID
    };
    
    int raw_axis_data_to_int(signed char raw_axis_data);
    char get_axis_register(Axis axis);
    double g_force_from_int_axis_data(const int axis_data);
    double angle_from_int_axis_data(const int axis_data);
    
    class Accelerometer
    {
        public:        
            Accelerometer(
                PinName sda_pin, 
                PinName scl_pin,
                const int filter_size,
                const int slave_address = I2C_ACCELEROMETER_ADDRESS
                );
            
            void write_register(const char register_address, const char new_value);
            char read_register(const char register_address);
            
            //axis_data must be an array of length 6
            void read_all_axis(signed char* axis_data);
            void print_all_axis_data();
            
            void set_standby();
            void set_active();
            void init();
            
            //Read data from the 8 most significant bits (MSB) of a given axis
            int read_axis_data_8_bits(Axis axis);
            
            double get_angle_from_horizontal();
        
        private:
            I2C device;
            utility::MovingAverageFilter filter;
            const int slave_address;
            
    };
}
#endif