#include "HCSR05.h"

HCSR05::HCSR05(PinName trigPin, PinName echoPin, float ptime):
    _trig(trigPin), _echo(echoPin), _periode(ptime)
{
    _trig = 0;
    _echo.rise(callback(this, &HCSR05::interrupt1)); 
    _echo.fall(callback(this, &HCSR05::interrupt2));
    tick.attach(callback(this, &HCSR05::mesure), _periode);
}

void HCSR05::interrupt1()
{
    //t1= timer.read_us();
    timer.reset();
    timer.start();
}

void HCSR05::interrupt2()
{
      t2=timer.read_us();
      timer.stop();
      D=(340*t2*0.0001)/2.0;
}

void HCSR05::mesure()
{
    _trig=1;
    wait_us(15);
    _trig=0;
}

float HCSR05::get_distance()
{
    return D;
}
