/*
 * @author: NGUYEN Ngoc Trong Nghia
 * @brief: a simple library to get the coordinates x,y,z of a DWM1001 tag
 */
#ifndef _DWM_UART_H_
#define _DWM_UART_H_
#include "mbed.h"

#define HAL_UART_MAX_LENGTH            255
#define DWM_WRITE_TIMEOUT 600 //us
#define DWM_READ_TIMEOUT 3 //ms

/**
 * @brief DWM Error codes, returned from DWM1001 module
 */
#define DWM_OK                 (0)
#define DWM_ERR_INTERNAL    (-1)
#define DWM_ERR_BUSY           (-2)
#define DWM_ERR_INVAL_ADDR  (-3)
#define DWM_ERR_INVAL_PARAM   (-4)
#define DWM_ERR_OVERRUN     (-5)
#define DWM_ERR_I2C_ANACK   (-10)
#define DWM_ERR_I2C_DNACK   (-11)

/**
 * @brief Return value Error codes, returned from DWM API functions
 */
#define RV_OK 0      /*  ret value OK */
#define RV_ERR -1
#define RV_TIME -2      /*  ret value ERROR*/

typedef struct {
    int32_t x;
    int32_t y;
    int32_t z;
    uint8_t qf;
} dwm_pos;


class dwm
{
public:
    dwm(PinName tx_pin, PinName rx_pin, int baudrate);
    dwm_pos node_pos;
/*====================================================
 *                      API
 * ===================================================
 */ 
    
/*
 * @brief: la commande dans l'exemple du doc, pour tester
 * @param: non
 * @output: 0 - reussi
 *          1 - echec
 */
    int dwm_gpio_cfg_output();
/*
 * @brief: recuperer la position x, y, z, qui seront stockes dans pos
 * @param: la struc dwm_pos
 * @output: 0 - reussi
 *          1 - echec
 */
    int dwm_pos_get();
//======================================
//              PRIVATE
//=====================================
private:
    Serial dwm_uart;
    
    //vider le buffer rx de nucleo
    void  flushSerialBuffer();
/*
 * @brief:  envoyer la commande
 * @param:  *tx_buffer - le tableau pour la commande
            len - la longeur du commande
 * @output: 0 - reussi
 *          -1 - echec
 */
    int uart_write(uint8_t* tx_buffer, uint8_t len);
/*
 * @brief:  recevoir la commande
 * @param:  *rx_buffer - la reponse est stocke dans rx_buffer
 * @output: la longeur de la reponse
 *          -1 - echec
 */
    int uart_read(uint8_t* rx_buffer, int len_prevu);
};
#endif //_DWM_UART_H_