#include "CMPS03.h"

CMPS03::CMPS03(PinName pwm) : _boussole(pwm)
{
    init = true;
    _boussole.rise(callback(this, &CMPS03::rise));
    _boussole.fall(callback(this, &CMPS03::fall));
    _boussole.enable_irq();
    
}

void CMPS03::rise(void)
{
    _tim.reset();
    _tim.start();
    //_startTime = _tim.read_us();
}

void CMPS03::fall(void)
{
    _stopTime = _tim.read_us();
    if(init == true)
    {
        init = false;
        offset = ((double)(_stopTime - 1000)/100.0);//-360;
    }
    _pwmBearing = ((double)(_stopTime - 1000)/100.0)-offset;
    if(_pwmBearing < 0) _pwmBearing+=360;
    _pwmBearing = 180 - _pwmBearing;
    if(_pwmBearing < 0) _pwmBearing+=360;
}

double CMPS03::getBearing(void)
{
    return _pwmBearing;
}

CMPS03::operator double()
{
    return _pwmBearing;
}