#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"
#include "eeprom.h"

#define PPV_BOB         1720 //  (40/15)*800
#define PPV_AMA         880 //  (
#define PPMM_AVA        7.8 //   800/103

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

void proc_motores(void);
void proc_ts(void);
void tela_principal(void);

DigitalOut led(PG_14);
DigitalOut pulso_cabo(PE_2);
DigitalOut pulso_ama(PE_3);
DigitalOut pulso_fit(PE_4);
DigitalOut dir_ama(PE_5);
DigitalOut lp_vermelha(PE_6);
DigitalOut vl_pesca(PB_4);
DigitalOut vl_corta(PB_7);
DigitalOut ena_cabo(PF_6);

DigitalIn bt_emerg(PC_3);
DigitalIn bt_pausa(PC_11);
DigitalIn bt_reset(PC_12);
DigitalIn bt_posic(PC_13);
DigitalIn alarm_cabo(PA_5);
DigitalIn sn_cabo(PA_9);
DigitalIn sn_ama(PA_10);
DigitalIn sn_porta(PG_3);

Ticker int_ts;   
TS_StateTypeDef TS_State;

volatile uint16_t x, y;
uint8_t PARADA_SERVO = 0;
uint8_t POSICIONADO = 0;
uint8_t CONDICAO = 0;
uint8_t COND_ANT = 0;

uint16_t VOLTAS_CABO = 10;
uint16_t VOLTAS_FIT = 2;
uint16_t COMP_FIT = 100;
uint16_t VELO_CABO = 8000;
uint16_t PRODUCAO = 0;
float DESLOC = 0;
char text[10];
uint16_t VirtAddVarTab[NB_OF_VAR] = {0x0011, 0x0022, 0x0033, 0x0044, 0x0055, 0x0066};

void proc_ts(void)
{
    ts.GetState(&TS_State);      
    if (TS_State.TouchDetected)
    {
        x = TS_State.X;
        y = TS_State.Y;
        
        //sprintf((char*)text, "  %d  ", y);
        //lcd.DisplayStringAt(0, 0, (uint8_t *)&text, CENTER_MODE);
    }
}

void RODA_SERVO(uint16_t VL_INICIAL, uint16_t VL_FINAL, uint32_t PASSOS, uint8_t MOTOR)
{
    PARADA_SERVO = 0;
    uint16_t VELOCIDADE = VL_INICIAL;
    uint32_t PULSOS = 0;

    POSICIONADO = 0;
  
    while (PARADA_SERVO < 1)
    {
        if (VELOCIDADE < VL_FINAL) { if (VELOCIDADE < 8000) { VELOCIDADE+= 2000; } else { VELOCIDADE+= 5; } }
        switch(MOTOR)
        {
            case 0:
                pulso_cabo=1;
                wait_us(30+(10000-VELOCIDADE));
                pulso_cabo=0;
                break;
            case 1:
                pulso_fit=1;
                wait_us(30+(10000-VELOCIDADE));
                pulso_fit=0;
                break;
            case 2:
                pulso_ama=1;
                wait_us(30+(10000-VELOCIDADE));
                pulso_ama=0;
                break;
            case 3:
                pulso_cabo=1;
                wait_us(30+(10000-VELOCIDADE));
                pulso_cabo=0;
                break;
            case 4:
                pulso_ama=1;
                wait_us(30+(10000-VELOCIDADE));
                pulso_ama=0;
                break;
        }
        wait_us(40);
    
        PULSOS++;
    
        if (PULSOS>PASSOS) { PARADA_SERVO = 1; }
        if (!bt_emerg) { PARADA_SERVO = 2; }
        if (bt_pausa) { PARADA_SERVO = 3; }
        if (!sn_porta) { PARADA_SERVO = 4; }

        if (MOTOR == 0) // BOBINA
        {
            if ( PULSOS > PASSOS-200) { if (sn_cabo) { PARADA_SERVO = 5; POSICIONADO = 1; } }
        }

        if (MOTOR == 1) // AVANÇO FITILHO
        {
            //
        }

        if (MOTOR == 2) // AMARRA FITILHO
        {  
            if ( PULSOS > PASSOS-200) { if (sn_ama) { PARADA_SERVO = 5; POSICIONADO = 1; } }
        }

        if (MOTOR == 3) // REPOSICIONAR BOBINA
        {   
            if (sn_cabo) { PARADA_SERVO = 5; } 
        }

        if (MOTOR == 4) // REPOSICIONAR AMARRA
        {
            if (sn_ama) { PARADA_SERVO = 5; } 
        }
    
    }

  while (bt_pausa || bt_posic) {} 
}

void tela_principal(void)
{
    //TITULO
    BSP_LCD_SetFont(&Font24);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawRect(10, 4, 220, 30);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 9, (uint8_t *)"RTE15-01", CENTER_MODE);
    
    //LABEL PRODUÇÃO
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, 60, (uint8_t *)"PRODUCAO", CENTER_MODE);
    BSP_LCD_SetFont(&Font24);
    
    //QUANTIDADE PRODUZIDA
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(10, 80, 220, 50);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(10, 80, 220, 50);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(0, 95, (uint8_t *)"  0  ", CENTER_MODE);
    
    //BOTÃO ZERAR
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillRect(10, 140, 220, 40);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(10, 140, 220, 40);
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DisplayStringAt(0, 150, (uint8_t *)"ZERAR", CENTER_MODE);
    
    //STATUS
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(10, 210, 220, 50);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(10, 210, 220, 50);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.DisplayStringAt(0, 225, (uint8_t *)"   PRONTO   ", CENTER_MODE);
    
    //BOTÃO CONFIG
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillRect(10, 270, 220, 40);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(10, 270, 220, 40);
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DisplayStringAt(0, 280, (uint8_t *)"CONFIG.", CENTER_MODE);
 
}

void tela_config(void)
{
    uint8_t sair=0;
    uint16_t _y1 = 38;
    uint16_t _dy = 56;
    
    //TÍTULO
    lcd.Clear(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DrawRect(10, 4, 220, 30);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, 9, (uint8_t *)"CONFIG.", CENTER_MODE);
    
    //LABEL VOLTAS CABO
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, _y1+(_dy*0), (uint8_t *)"VOLTAS CABO", CENTER_MODE);
    BSP_LCD_SetFont(&Font24);
    
    //VOLTAS CABO
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(40, _y1+(_dy*0)+20, 160, 34);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(40, _y1+(_dy*0)+20, 160, 34);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    sprintf((char*)text, "  %d  ", VOLTAS_CABO);
    lcd.DisplayStringAt(0, _y1+(_dy*0)+28, (uint8_t *)&text, CENTER_MODE);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*0)+34, _y1+(_dy*0)+14, _y1+(_dy*0)+34);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*0)+40, _y1+(_dy*0)+60, _y1+(_dy*0)+40);
    
    //LABEL VOLTAS FITILHO
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.DisplayStringAt(0, _y1+(_dy*1), (uint8_t *)"VOLTAS FIT.", CENTER_MODE);
    BSP_LCD_SetFont(&Font24);
    
    //VOLTAS FITILHO
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(40, _y1+(_dy*1)+20, 160, 34);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(40, _y1+(_dy*1)+20, 160, 34);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    sprintf((char*)text, "  %d  ", VOLTAS_FIT);
    lcd.DisplayStringAt(0, _y1+(_dy*1)+28, (uint8_t *)&text, CENTER_MODE);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*1)+34, _y1+(_dy*1)+14, _y1+(_dy*1)+34);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*1)+40, _y1+(_dy*1)+60, _y1+(_dy*1)+40);
    
    //LABEL COMP FITILHO
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.DisplayStringAt(0, _y1+(_dy*2), (uint8_t *)"COMP FIT.", CENTER_MODE);
    BSP_LCD_SetFont(&Font24);
    
    //COMP FITILHO
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(40, _y1+(_dy*2)+20, 160, 34);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(40, _y1+(_dy*2)+20, 160, 34);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    sprintf((char*)text, "  %d  ", COMP_FIT);
    lcd.DisplayStringAt(0, _y1+(_dy*2)+28, (uint8_t *)&text, CENTER_MODE);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*2)+34, _y1+(_dy*2)+14, _y1+(_dy*2)+34);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*2)+40, _y1+(_dy*2)+60, _y1+(_dy*2)+40);
    
    //LABEL VELOCIDADE CABO
    BSP_LCD_SetFont(&Font20);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_GREEN);
    lcd.DisplayStringAt(0, _y1+(_dy*3), (uint8_t *)"VELOC. CABO", CENTER_MODE);
    BSP_LCD_SetFont(&Font24);
    
    //COMP FITILHO
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.FillRect(40, _y1+(_dy*3)+20, 160, 34);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(40, _y1+(_dy*3)+20, 160, 34);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    sprintf((char*)text, "  %d  ", VELO_CABO);
    lcd.DisplayStringAt(0, _y1+(_dy*3)+28, (uint8_t *)&text, CENTER_MODE);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*3)+34, _y1+(_dy*3)+14, _y1+(_dy*3)+34);
    lcd.FillTriangle(210, 220, 230, _y1+(_dy*3)+40, _y1+(_dy*3)+60, _y1+(_dy*3)+40);
    
    
    //BOTÃO SAIR
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillRect(10, 270, 220, 40);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DrawRect(10, 270, 220, 40);
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_DARKGRAY);
    lcd.DisplayStringAt(0, 280, (uint8_t *)"SAIR", CENTER_MODE);
    
    while(sair<1)
    {
        
        if(y>(_y1+(_dy*0)+14) && y<(_y1+(_dy*0)+34) && x>200) // + VOLTAS CABO
        {
            y=0; x=0;
            if (VOLTAS_CABO<60) 
            { 
                VOLTAS_CABO+=5;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VOLTAS_CABO);
                lcd.DisplayStringAt(0, _y1+(_dy*0)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.3);
        }
        
        if(y>(_y1+(_dy*0)+40) && y<(_y1+(_dy*0)+60) && x>200) // - VOLTAS CABO
        {
            y=0; x=0;
            if (VOLTAS_CABO>10)
            {
                VOLTAS_CABO-=5;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VOLTAS_CABO);
                lcd.DisplayStringAt(0, _y1+(_dy*0)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.3);
        }
        
        if(y>(_y1+(_dy*1)+14) && y<(_y1+(_dy*1)+34) && x>200) // + VOLTAS FITILHO
        {
            y=0; x=0;
            if (VOLTAS_FIT<8)
            {
                VOLTAS_FIT+=1;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VOLTAS_FIT);
                lcd.DisplayStringAt(0, _y1+(_dy*1)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.3);
        }
        
        if(y>(_y1+(_dy*1)+40) && y<(_y1+(_dy*1)+60) && x>200) // - VOLTAS FITILHO
        {
            y=0; x=0;
            if (VOLTAS_FIT>2)
            {
                VOLTAS_FIT-=1;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VOLTAS_FIT);
                lcd.DisplayStringAt(0, _y1+(_dy*1)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.3);
        }
        
        if(y>(_y1+(_dy*2)+14) && y<(_y1+(_dy*2)+34) && x>200) // + COMPRIMENTO FITILHO
        {
            y=0; x=0;
            if (COMP_FIT<250)
            {
                COMP_FIT+=1;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", COMP_FIT);
                lcd.DisplayStringAt(0, _y1+(_dy*2)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.1);
        }
        
        if(y>(_y1+(_dy*2)+40) && y<(_y1+(_dy*2)+60) && x>200) // - COMPRIMENTO FITILHO
        {
            y=0; x=0;
            if (COMP_FIT>100)
            {
                COMP_FIT-=1;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", COMP_FIT);
                lcd.DisplayStringAt(0, _y1+(_dy*2)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.1);
        }
        
        if(y>(_y1+(_dy*3)+14) && y<(_y1+(_dy*3)+34) && x>200) // + VELOCIDADE CABO
        {
            y=0; x=0;
            if (VELO_CABO<9900)
            {
                VELO_CABO+=100;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VELO_CABO);
                lcd.DisplayStringAt(0, _y1+(_dy*3)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.1);
        }
        
        if(y>(_y1+(_dy*3)+40) && y<(_y1+(_dy*3)+60) && x>200) // - VELOCIDADE CABO
        {
            y=0; x=0;
            if (VELO_CABO>4000)
            {
                VELO_CABO-=100;
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                sprintf((char*)text, "  %d  ", VELO_CABO);
                lcd.DisplayStringAt(0, _y1+(_dy*3)+28, (uint8_t *)&text, CENTER_MODE);
            }
            wait(0.1);
        }
        
        if(y>270) // sair
        {
            y=0; x=0;
            EE_WriteVariable(VirtAddVarTab[0], VOLTAS_CABO);
            EE_WriteVariable(VirtAddVarTab[1], VOLTAS_FIT);
            EE_WriteVariable(VirtAddVarTab[2], COMP_FIT);
            EE_WriteVariable(VirtAddVarTab[3], VELO_CABO);
            sair=1;
        }
    }
}

void status(void)
{
    COND_ANT = CONDICAO;
  
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLUE);
  
    if (!sn_porta) { CONDICAO = 7; }
    if (!bt_emerg) { CONDICAO = 8; }
    
    //CONDICAO = 0;
    
    switch (CONDICAO)
    {
        case 0:
            lcd.DisplayStringAt(0, 225, (uint8_t *)" POSICIONAR ", CENTER_MODE);
            lp_vermelha = 0;
            break;
        case 1:
            lcd.DisplayStringAt(0, 225, (uint8_t *)"   PRONTO   ", CENTER_MODE);
            lp_vermelha = 0;
            break;
        case 6:
            lcd.DisplayStringAt(0, 225, (uint8_t *)"    FIM     ", CENTER_MODE);
            lp_vermelha = 0;
            break;
        case 7:
            lcd.DisplayStringAt(0, 225, (uint8_t *)"PORTA ABERTA", CENTER_MODE);
            break;
        case 8:
            lcd.DisplayStringAt(0, 225, (uint8_t *)" EMERGENCIA ", CENTER_MODE);
          break;          
        default:
            lcd.DisplayStringAt(0, 225, (uint8_t *)"EM TRABALHO ", CENTER_MODE);
            lp_vermelha = 1;
          break;
    }

    while (CONDICAO == 8)
    {
        lp_vermelha = 1;
        wait(0.4);
        lp_vermelha = 0;
        wait(0.4);
        if (!bt_emerg) { CONDICAO = 8; } else { CONDICAO = 0; }   
    }

    CONDICAO = COND_ANT;

    if(y>140 && y<180) // ZERAR PRODUÇÃO
    { 
        x=0; y=0;
        PRODUCAO = 0;
        EE_WriteVariable(VirtAddVarTab[4], 0);
    }
    sprintf((char*)text, "  %d  ", PRODUCAO);
    lcd.DisplayStringAt(0, 95, (uint8_t *)&text, CENTER_MODE);
    
    if (y>270) // CONFIGURAÇÕES
    {
        x=0; y=0;
        tela_config();
        tela_principal();
        wait(1);
    } 
}

 
int main()
{
    int_ts.attach(&proc_ts, 0.05);
    ts.Init(lcd.GetXSize(), lcd.GetYSize());
    
    HAL_FLASH_Unlock();
    EE_Init();
    EE_ReadVariable(VirtAddVarTab[0], &VOLTAS_CABO);
    EE_ReadVariable(VirtAddVarTab[1], &VOLTAS_FIT);
    EE_ReadVariable(VirtAddVarTab[2], &COMP_FIT);
    EE_ReadVariable(VirtAddVarTab[3], &VELO_CABO);
    EE_ReadVariable(VirtAddVarTab[4], &PRODUCAO);
    
    tela_principal();
    
    dir_ama=1;
                  
    while(true) 
    {
        status();
        while (POSICIONADO < 1)
        {
            CONDICAO = 0; status();
    
            if ( bt_posic && sn_porta && bt_emerg )
            {
                while (bt_posic) {}

                ena_cabo=1;
                RODA_SERVO(2000, 9000, PPV_BOB, 3); // REPOSICIONA BOBINA

                RODA_SERVO(2000, 9000, PPV_AMA, 4); // REPOSICIONA AMARRA

                if ( sn_cabo && sn_ama ) { POSICIONADO = 1; CONDICAO = 1; status(); }      
            }   
        }
        
        if (!sn_ama) { POSICIONADO = 0; }
  
        if ( bt_pausa && sn_porta && bt_emerg )
        {
            while (bt_pausa) {}
    
            CONDICAO = 2; status();
            ena_cabo=1;
            wait(0.1);

            DESLOC = ((float)PPV_BOB*((float)VOLTAS_CABO/10))+200;
            RODA_SERVO(2000, VELO_CABO, (int)DESLOC, 0);                // Processa cabo
            if ( PARADA_SERVO == 5 )                                    // Se parada correta no cabo, continua ciclo
            {
                CONDICAO = 3; 
                vl_pesca=1;                                             // Aciona PESCA
                RODA_SERVO(4000, 9000, PPMM_AVA*COMP_FIT, 1);           // Processa avanço
                vl_pesca=0;                                             // Recua PESCA
                wait(0.2);
                if ( PARADA_SERVO == 1 )                                // Se parada correta do avanço, continua ciclo
                {
                    CONDICAO = 4; 
                    DESLOC = (float)PPV_AMA/2;
                    RODA_SERVO(5000, 9900, (int)DESLOC, 1);             // Processa pré amarra
                    if ( PARADA_SERVO == 1 )                            // Se parada correta da pre amarra, continua ciclo
                    {
                        CONDICAO = 5; 
                        vl_corta=1;                                                 // Aciona FACA
                        DESLOC = ((PPV_AMA*VOLTAS_FIT)-(float)PPV_AMA/2)+200;
                        RODA_SERVO(5000, 9900, (int)DESLOC, 2);                     // Processa restante da amarra
                        vl_corta=0;               
                        if ( PARADA_SERVO == 5 ) { CONDICAO = 6; PRODUCAO++; EE_WriteVariable(VirtAddVarTab[4], PRODUCAO); status(); }        // Se parada correta da amarra, indica FIM (Condição 6)
                        while (sn_porta){}                                          // Espera abrir a porta
                        CONDICAO = 1; status();
                    }
                }  
            }
            vl_corta=0;                                                 // Recua FACA
            vl_pesca=0;                                                 // Recua PESCA
        }
        
    }
}