#include "mbed.h"
#include "TextLCD.h"

BusOut onda(D2, D3, D4, D5);
TextLCD display(PC_9, PC_8, PC_10, PC_12, PA_13, PA_14, TextLCD::LCD20x4);


DigitalIn BA(D5); //Botão A
DigitalIn BB(D6); //Botão B
DigitalIn BC(D7); //Botão C

int i=0;
int z=0;
int x=0;
int state=1;
int temp;
unsigned  char Sen []={7,9,11,12,13,14,15,15,15,15,14,13,12,11,9,7,6,4,3,2,1,0,0,0,0,1,2,3,4,6};


int main(){
    
    display.cls();
    display.printf("Tipos de Onda: \n");
    display.printf("A - Onda Quadrada\n");
    display.printf("B - Onda Triangular\n");
    display.printf("C - Onda Senoidal\n");

    //Onda Quadrada
    if (BA<0.5) {
        display.cls();
        display.printf("Frequencia:\n");
        display.printf("A - 500 Hz\n");
        display.printf("B - 300,12 Hz\n");
        while (1) { //Escolhendo a Frequencia
            if (BA<0.5) { //500Hz
                temp=1000;
                break;
            }
            if (BB<0.5) { //300,12Hz
                temp=1666;
                break;
            }
        }
        display.cls();
        display.printf("Gerando Quadrada\n");
        display.printf("B - Parar\n");
        while (BB>0.5) { //Apertar B para parar onda
            x=0;
            onda=x;
            printf("%i",x);
            wait_us(temp);
            x=15;
            onda=x;
            printf("%i",x);
            wait_us(temp);
        }
    }
    //Onda Triangular
    if (BB<0.5) {
        display.cls();
        display.printf("Frequencia:\n");
        display.printf("A - 505,05 Hz\n");
        display.printf("B - 300,30 Hz\n");
        while (1) { //Escolhendo a Frequencia
            if (BA<0.5) { //505,05Hz
                temp=66;
                break;
            }
            if (BB<0.5) { //300,30Hz
                temp=111;
                break;
            }
        }
        display.cls();
        display.printf("Gerando Triangular\n");
        display.printf("B - Parar\n");
        while (BB>0.5) { //Apertar B para parar onda
            if (state==1) {
                onda=i;
                wait_us(temp);
                printf("%i\n",i);
                i=i+1;
                if (i==15) {
                    state=2;
                }
            }
            if (state==2) {
                onda=i;
                wait_us(temp);
                printf("%i\n",i);
                i=i-1;
                if (i==0) {
                    state=1;
                }
            }
        }
    }
    
    
   //Onda Senoidal
    if (BC<0.5) {
        display.cls();
        display.printf("Frequencia:\n");
        display.printf("A - 505,05 Hz\n");
        display.printf("B - 300,30 Hz\n");
        while (1) { //Escolhendo a Frequencia
            if (BA<0.5) { //505,05Hz
                temp=66;
                break;
            }
            if (BB<0.5) { //300,30Hz
                temp=111;
                break;
            }
        }
        display.cls();
        display.printf("Gerando Senoidal\n");
        display.printf("B - Parar\n");
        while (BB>0.5) { //Apertar B para parar onda
            onda=Sen[z];
            printf("%i",z);
            wait_us(temp);
            if (z==29) {
                z=0;
            }
            else{
                z=z+1;
            }
        }
    }

}
