#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
//DISPLAY        abcdefg
#define CERO   0b1111110
#define UNO    0b0110000
#define DOS    0b1101101
#define TRES   0b1111001
#define CUATRO 0b0110011
#define CINCO  0b1011011
#define SEIS   0b1011111
#define SIETE  0b1110000
#define OCHO   0b1111111
#define NUEVE  0b1111011
//LED
#define LED_ON  0
#define LED_OFF 1
#define NADA   99 // estado en el que todos los cables estan conectados
#define ON 1
#define OFF 0
//-------------------------BUS DE SALIDA PARA DISPLAY-------------------------//
BusOut display(PTC7,PTC0,PTC3,PTC4,PTC5,PTC6,PTC10);// de g--a
//-----------------------------ENTRADA DE CABLES------------------------------//
DigitalIn a0 (PTB0);
DigitalIn a1 (PTB1);
DigitalIn a2 (PTB2);
DigitalIn a3 (PTB3);
//------------------------------SALIDA DE LEDS--------------------------------//
DigitalOut led_r(LED_RED);
DigitalOut led_v(LED_GREEN);
//----------------------SALIDAS DE DISPLAY PARA BARRIDO-----------------------//
DigitalOut display_2(PTC8);
DigitalOut display_1(PTC9);
//----------------------------FUNCIONES DE TIMER------------------------------//
void timer();
void deteccion_cables();
void titilacion_led();
//--------------------------------FUNCIONES-----------------------------------//
void secuencia_bomba();
void muestra_display();
void numero_display();
//------------------------------TEMPORIZADORES--------------------------------//
Ticker ti;
Ticker t_muestra_display;
Ticker t_titilacion_led;


bool verificacion_0 = false;
bool verificacion_1 = false;
bool verificacion_2 = false;
bool verificacion_3 = false;
bool errores = false;
bool a = false;
bool botones = false;


uint8_t tiempo = 30;
uint8_t secuencia[4], random, turno = 0, displays;

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

enum {
    encendido,
    verificacion
} juego;

int main(void)
{
    __enable_irq();
    srand(random);

    a0.mode(PullUp);
    a1.mode(PullUp);
    a2.mode(PullUp);
    a3.mode(PullUp);

    led_r = LED_OFF;
    led_v = LED_OFF;
    display_1=1;
    display_2=1;
    juego = encendido;

    while (true) {
        /*
        PARA EMPEZAR, HAY QUE COLOCAR TODOS LOS CABLES A MASA Y TOCAR EL TSI.
        CUANDO SE CUPLE TODO LO ANTERIOR, EL JUEGO EEMPIEZA, CREA LA SECUENCIA
        Y EMPIEZA EL DESCUENTRO DEL TIEMPO.
        */
        switch (juego) {
//--------------------------------ENCENDIDO-----------------------------------//
            case encendido:
                if (a == false) {
                    printf("para empezar conecte los cables y toque el TSI\n");
                    a = true;
                }
//------------------ESPERO A QUE LOS CABLES ESTEN EN MASA---------------------//
                if(!a0 && !a1 && !a2 && !a3 && botones == false) {
                    verificacion_1 = false;
                    verificacion_2 = false;
                    verificacion_3 = false;
                    verificacion_0 = false;
                    botones = true;
                }
//--------------------ESPERO A QUE SE PRECIONE EL TSI-------------------------//
                if (0.0 < tsi.readPercentage() &&
                        1 > tsi.readPercentage() &&
                        botones == true) {
                    secuencia_bomba();
                    botones = false;
                    errores = false;
                    a = false;
                    tiempo = 30; // TIEMPO EN 30 SEGUNDOS
                    ti.attach(&timer, 1); //INICIA ES DESCUENTO DEL TIEMPO
                    t_muestra_display.attach(&muestra_display, 0.01);
                    juego = verificacion;
                }
                break;
//-------------------------------VERIFICACION---------------------------------//
            case verificacion:
                t_titilacion_led.detach();// DESACTIVO LA TITILACION DE LED
                led_r = LED_OFF;
                led_v = LED_OFF;
                deteccion_cables();
//-------------------------------VERIFICACION---------------------------------//
                if (errores == true) {
                    printf("you lose\n");
                    turno = 0;
                    juego = encendido;
                    ti.detach();
                    t_titilacion_led.attach(&titilacion_led, 0.5);
                }
//-------------------------------VERIFICACION---------------------------------//
                if (turno == 4) {
                    printf("you won\n");
                    ti.detach();
                    turno = 0;
                    juego = encendido;
                    led_v = LED_ON;
                }
                break;
        }
    }
}
//-------------------CREA LA SECUENCIA RANDOM DE LA BOMBA---------------------//
void secuencia_bomba()
{
    uint8_t i, valor;
    valor = rand() % 24;

    switch(valor) {
        case 0:
            secuencia[0]=0, secuencia[1]=1, secuencia[2]=2, secuencia[3]=3;
            break;
        case 1:
            secuencia[0]=0, secuencia[1]=1, secuencia[2]=3, secuencia[3]=2;
            break;
        case 2:
            secuencia[0]=0, secuencia[1]=2, secuencia[2]=1, secuencia[3]=3;
            break;
        case 3:
            secuencia[0]=0, secuencia[1]=2, secuencia[2]=3, secuencia[3]=1;
            break;
        case 4:
            secuencia[0]=0, secuencia[1]=3, secuencia[2]=2, secuencia[3]=1;
            break;
        case 5:
            secuencia[0]=0, secuencia[1]=3, secuencia[2]=1, secuencia[3]=2;
            break;
        case 6:
            secuencia[0]=1, secuencia[1]=0, secuencia[2]=2, secuencia[3]=3;
            break;
        case 7:
            secuencia[0]=1, secuencia[1]=0, secuencia[2]=3, secuencia[3]=2;
            break;
        case 8:
            secuencia[0]=1, secuencia[1]=2, secuencia[2]=0, secuencia[3]=3;
            break;
        case 9:
            secuencia[0]=1, secuencia[1]=2, secuencia[2]=3, secuencia[3]=0;
            break;
        case 10:
            secuencia[0]=1, secuencia[1]=3, secuencia[2]=2, secuencia[3]=0;
            break;
        case 11:
            secuencia[0]=1, secuencia[1]=3, secuencia[2]=0, secuencia[3]=2;
            break;
        case 12:
            secuencia[0]=2, secuencia[1]=1, secuencia[2]=0, secuencia[3]=3;
            break;
        case 13:
            secuencia[0]=2, secuencia[1]=1, secuencia[2]=3, secuencia[3]=0;
            break;
        case 14:
            secuencia[0]=2, secuencia[1]=0, secuencia[2]=1, secuencia[3]=3;
            break;
        case 15:
            secuencia[0]=2, secuencia[1]=0, secuencia[2]=3, secuencia[3]=1;
            break;
        case 16:
            secuencia[0]=2, secuencia[1]=3, secuencia[2]=0, secuencia[3]=1;
            break;
        case 17:
            secuencia[0]=2, secuencia[1]=3, secuencia[2]=1, secuencia[3]=0;
            break;
        case 18:
            secuencia[0]=3, secuencia[1]=1, secuencia[2]=2, secuencia[3]=0;
            break;
        case 19:
            secuencia[0]=3, secuencia[1]=1, secuencia[2]=0, secuencia[3]=2;
            break;
        case 20:
            secuencia[0]=3, secuencia[1]=2, secuencia[2]=1, secuencia[3]=0;
            break;
        case 21:
            secuencia[0]=3, secuencia[1]=2, secuencia[2]=0, secuencia[3]=1;
            break;
        case 22:
            secuencia[0]=3, secuencia[1]=0, secuencia[2]=2, secuencia[3]=1;
            break;
        case 23:
            secuencia[0]=3, secuencia[1]=0, secuencia[2]=1, secuencia[3]=2;
            break;
    }
    for(i=0; i<4; i++) {
        printf("%d, cable numero %d\n",i+1,secuencia[i]);
    }
}
//----------------------MUESTRA EL TIEMPO EN EL DISPLAY-----------------------//
void muestra_display()
{
    static uint8_t numero=0;
    switch(numero) {
        case 0:
            display_2 = 1;
            display_1 = 0;
            displays = tiempo/10;
            numero++;
            numero_display();
            break;
        case 1:
            display_1 = 1;
            display_2 = 0;
            displays = tiempo%10;
            numero = 0;
            numero_display();
            break;
    }
}
void numero_display()
{
    switch(displays) {
        case 0:
            display = CERO;
            break;
        case 1:
            display = UNO;
            break;
        case 2:
            display = DOS;
            break;
        case 3:
            display = TRES;
            break;
        case 4:
            display = CUATRO;
            break;
        case 5:
            display = CINCO;
            break;
        case 6:
            display = SEIS;
            break;
        case 7:
            display = SIETE;
            break;
        case 8:
            display = OCHO;
            break;
        case 9:
            display = NUEVE;
            break;
    }
}
//----------------------------DETECCION DE CABLES-----------------------------//
void deteccion_cables()
{
    if (a0 == ON && verificacion_0 == false) {
        verificacion_0 = true;
        (secuencia[turno] == 0 ? turno++ : errores = true);
    }
    if (a1 == ON && verificacion_1 == false) {
        verificacion_1 = true;
        (secuencia[turno] == 1 ? turno++ : errores = true);
    }

    if (a2 == ON && verificacion_2 == false) {
        verificacion_2 = true;
        (secuencia[turno] == 2 ? turno++ : errores = true);
    }
    if (a3 == ON && verificacion_3 == false) {
        verificacion_3 = ON;
        (secuencia[turno] == 3 ? turno++ : errores = true);
    }
}
void timer()
{
    if(tiempo > 0)
        tiempo--;
    else {
        printf("se acabo el tiempo\n");
        errores = true;
        ti.detach();
    }
}
void titilacion_led()
{
    led_r =! led_r;
}