#include "mbed.h"

#define ON  0
#define OFF 1

#define LED_ON  0
#define LED_OFF 1
#define NADA    99
//------------------------------SALIDA DE LEDS--------------------------------//
DigitalOut led_r(LED_RED);
DigitalOut led_a(LED_BLUE);
DigitalOut led_v(LED_GREEN);
//---------------------------ENTRADA DE PULSADORES----------------------------//
DigitalIn boton_0 (PTC12);
DigitalIn boton_1 (PTC13);
DigitalIn boton_2 (PTC16);
//----------------------------MAQUINA PRINCIPAL-------------------------------//
enum {
    INICIO,
    SECUENCIA_LED,
    MUESTRA_SECUENCIA,
    DETECCION
} maq_principal;
//------------------------MAQUINA DE MUESTRA DE LEDS--------------------------//
enum {
    MUESTRA_LED,
    LED_R_ON,
    LED_V_ON,
    LED_A_ON
} maq_leds;
//---------------------MAQUINA DE DETTECION DE PULSADORES---------------------//
enum {
    DETT_PULS,
    BOTON_0_ON,
    BOTON_1_ON,
    BOTON_2_ON
} maq_botones;
//----------------MAQUINA DE DETECCION DE PULSADOR DE INICIO------------------//
enum {
    DETT,
    ESP
} encendido;
//-------------------------------FUNCIONES------------------------------------//
void pulsador_on();
void muestra_de_leds();
void deteccion_de_puls();
//---------------------------FUNCION PARA TIMER-------------------------------//
void timer();
Ticker ti;
int t_juego = 0;
bool toff = false;
bool errores = false;
bool a = false;

uint8_t boton = NADA,random;
uint8_t turno = 0, turno_acciones = 0;
int t_led = 0, t_espera=0, t_juego = 0;// VARIABLES PARA TEMPORIZADORES
uint8_t secuencia[24];


int main()
{
    __enable_irq();
//-----------------------PULL UP PARA LOS PULSADORES--------------------------//
    boton_0.mode(PullUp);
    boton_1.mode(PullUp);
    boton_2.mode(PullUp);
//----------------------------------------------------------------------------//
    encendido = DETT;
    maq_botones = DETT_PULS;
    maq_principal = INICIO;
    maq_leds = MUESTRA_LED;
    srand(random);

    ti.attach(&timer,0.01);
/*
    EL PROGRAMA EMPIEZA ESPERANDO LA SEÑAL DEL PULSADOR DE INICIO.
    UNA VEZ PULSADO, EMPIEZA EL JUEGO, ENTRE CADA PULSO HAY 5 SEGUNDOS DE ESPERA
    SI LLEGA A LOS 5 SEGUNDOS Y NO SE PRESIONO NINGUN BOTON, PIERDES Y EL JUEGO
    SE REINICIA.
    LA SECUENCIA SE VA A IR GENERANDO A MEDIDA QUE VA AVANZANDO EL JUEGO.
*/
    while(1) {
        switch (maq_principal) {
            case INICIO:
                if (a == false) {
                    printf("toque el primer boton para comenzar\n");
                    a = true;
                }
                pulsador_on();
                led_r = LED_ON;
                led_a = LED_ON;
                led_v = LED_ON;
                if (boton == 5) {
                    boton = NADA;
                    turno = 0;
                    maq_principal = SECUENCIA_LED;
                }
                break;
            case SECUENCIA_LED:
                if (turno == 24) {
                    maq_principal = INICIO;
                    printf("you won \n");
                }
                if (turno < 24) {
                    secuencia[turno] = rand () % 3;
                    t_led = 50;
                    maq_principal = MUESTRA_SECUENCIA;
                }
                break;
            case MUESTRA_SECUENCIA:
                muestra_de_leds();
                if (t_led == 0 && turno_acciones > turno) {
                    turno_acciones = 0;
                    t_juego = 500;
                    maq_principal = DETECCION;
                }
                break;
            case DETECCION:
                deteccion_de_puls();
                if (errores == true) {
                    printf("you lose\n");
                    maq_principal = INICIO;
                }
                if (t_juego == 0) {
                    printf("se acabo el tiempo\n");
                    maq_principal = INICIO;
                }
                if (turno_acciones > turno) {
                    turno_acciones = 0;
                    turno++;
                    maq_principal = SECUENCIA_LED;
                }
        }
    }
}

void pulsador_on()
{
    switch(encendido) {
        case DETT:
            if (boton_0 == ON && t_espera == 0) {
                t_espera = 5;
                toff = false;
                encendido = ESP;
            }
            break;
        case ESP:
            if (t_espera == 0 && toff == false && boton_0 == OFF) {
                t_espera = 5;
                toff = true;
            }
            if(t_espera == 0 && toff == true) {
                boton = 5;
                encendido = DETT;
            }
            break;
    }
}
/*
    SE VAN MOSTRANDO LA SECUENCIA DE LOS LED, SE VA A MOSTRAR POR 1 SEGUNDO Y
    VA A ESTAR APAGADO POR 0.5 SEGUNDOS, DE ESTA FORMA SE LO PUEDE DIFERENCIAR
    DE OTRA SECUENCIA CON EL MISMO COLOR.
*/
void muestra_de_leds()
{
    switch (maq_leds) {
        case MUESTRA_LED:
            led_r = LED_OFF;
            led_a = LED_OFF;
            led_v = LED_OFF;
            if (t_led == 0 && turno_acciones <= turno) {
                if(secuencia[turno_acciones] == 0) {
                    maq_leds = LED_R_ON;
                    t_led = 100;
                }
                if(secuencia[turno_acciones] == 1) {
                    maq_leds = LED_V_ON;
                    t_led = 100;
                }
                if(secuencia[turno_acciones] == 2) {
                    maq_leds = LED_A_ON;
                    t_led = 100;
                }
            }
            break;
        case LED_R_ON:
            led_r = LED_ON;
            led_a = LED_OFF;
            led_v = LED_OFF;
            if (t_led == 0) {
                turno_acciones++;
                t_led = 50;
                maq_leds = MUESTRA_LED;
            }
            break;
        case LED_V_ON:
            led_r = LED_OFF;
            led_a = LED_OFF;
            led_v = LED_ON;
            if (t_led == 0) {
                turno_acciones++;
                t_led = 50;
                maq_leds = MUESTRA_LED;
            }
            break;
        case LED_A_ON:
            led_r = LED_OFF;
            led_a = LED_ON;
            led_v = LED_OFF;
            if (t_led == 0) {
                turno_acciones++;
                t_led = 50;
                maq_leds = MUESTRA_LED;
            }
            break;
    }
}
/*
    LOS BOTONES ESTAN PROGRAMADOS PARA QUE SE ACTIVEN CON FLANCO DESCENDENTE,
    ENTONCES SI LOS PRESIONAN, PRIMERO VA A CONTAR 50MS DE ANTIREBOTE Y ESPERA
    A QUE SUELTEN EL BOTON, UNA VEZ SOLTADO EL BOTON, VA A ESPERAR OTROS 50MS 
    DE ANTIRREBOTE Y ES ESE PUNTO DETECTA EL BOTON.
*/
void deteccion_de_puls()
{
    switch(maq_botones) {
        case DETT_PULS:
            led_r = LED_OFF;
            led_a = LED_OFF;
            led_v = LED_OFF;
            if (t_juego > 0 && turno_acciones <= turno && errores == false) {
                if (boton_0 == ON && t_espera == 0) {
                    t_espera = 5;
                    toff = false;
                    led_r = LED_ON;
                    maq_botones = BOTON_0_ON;
                }
                if (boton_1 == ON && t_espera == 0) {
                    t_espera = 5;
                    toff = false;
                    led_v = LED_ON;
                    maq_botones = BOTON_1_ON;
                }
                if (boton_2 == ON && t_espera == 0) {
                    t_espera = 5;
                    toff = false;
                    led_a = LED_ON;
                    maq_botones = BOTON_2_ON;
                }
            }
            break;
        case BOTON_0_ON:
            if (t_espera == 0 && toff == false && boton_0 == OFF) {
                t_espera = 5;
                toff = true;
            }
            if (t_espera == 0 && toff == true) {
                boton = 0;
                if (boton == secuencia[turno_acciones]) {
                    turno_acciones++;
                    t_juego = 500;
                } else {
                    errores = true;
                }
                maq_botones = DETT_PULS;
                boton = NADA;
            }
            break;
        case BOTON_1_ON:
            if (t_espera == 0 && toff == false && boton_1 == OFF) {
                t_espera = 5;
                toff = true;
            }
            if (t_espera == 0 && toff == true) {
                boton = 1;
                if (boton == secuencia[turno_acciones]) {
                    turno_acciones++;
                    t_juego = 500;
                } else {
                    errores = true;
                }
                maq_botones = DETT_PULS;
                boton = NADA;
            }
            break;
        case BOTON_2_ON:
            if (t_espera == 0 && toff == false && boton_2 == OFF) {
                t_espera = 5;
                toff = true;
            }
            if (t_espera == 0 && toff == true) {
                boton = 2;
                if (boton == secuencia[turno_acciones]) {
                    turno_acciones++;
                    t_juego = 500;
                } else {
                    errores = true;
                }
                maq_botones = DETT_PULS;
                boton = NADA;
            }
            break;
    }
}
void timer ()
{
    if(t_led > 0)
        t_led--;
    if(t_espera > 0)
        t_espera--;
    if(t_juego > 0)
        t_juego--;
}