//Incluyo las librerias a utilizar
#include "mbed.h"
#include "DS1820.h"

DS1820    probe(A0);      //Defino el pin digital de entrada del sensor de temperatura. A0=PTB0.
AnalogIn  preset(A1);     //Defino el pin de entrada analógico del preset. A1=PTB1.

InterruptIn cooler(PTD4); // Defino la interrupcion de entrada para la salida del sensor hall

DigitalIn pulsador(PTC7); //Defino la entrada digital del pulsador.
PwmOut    motor(PTA13);   //Salida PWM para alimentar el motor con su interfaz.

Ticker pulso; //Ticker utilziado para detectar si se presiono el pulsador.
Ticker llamo; //Ticker utilziado para llamar a uno de los lazos cada cierto tiempo.


void velocidad(); //Prototipo de la funcion velocidad.
void detector(); //Prototipo de la funcion detector.
void lazo(); //Prototipo de la funcion lazo.

//Defino todas las variables:
int verificacion=0, modo=0, rebote=0;
int vuelta=0, pulsos=0, temperatura=0;


int main()
{
    //Habilito las interrupciones.
    __enable_irq();
    //Cada vez que recibe un flanco ascendente del motor, interrumpe.
    cooler.rise(&velocidad);
    //Cada 10ms se fija el estado del pulsador.
    pulso.attach(&detector,0.01);
    //R de pull-up interno
    pulsador.mode(PullUp);
    //Cada un segundos, se llama a la funcion lazo.
    llamo.attach(&lazo, 1);
    //En el while (true) no hay nada.
    while(true) {}
}

//Funcion que detecta si se presiona el pulsador ademas de eliminarle el rebote.
void detector()
{
    if (pulsador==0 && verificacion==0) {
        verificacion=1;
        rebote=4;
    }
    if (pulsador==0 && verificacion==1) {
        if (rebote>0)
            rebote--;
    }
    if(rebote==0 && verificacion==1 && pulsador==1) {
        verificacion=0;
        modo=!modo; //Invierte el modo de operacion de lazo cerrado a abierto y viceversa.
    }
}

void lazo()
{
    vuelta=pulsos/2*60; //El micro recibe dos pulsos del sensor hall del motor cada vez que da una vuelta.

    if (modo==0) { //Cuando el modo es el de lazo abierto
        probe.convertTemperature(false, DS1820::all_devices);         //Obtiene la temperatura y la almacena en probe.temperature
        temperatura = probe.temperature();                            //Guardo dicha temperatura en otra variable
        printf("%3.1f grados", probe.temperature());                  //Imprimo la temperatura
        printf("          %1.2f porciento",preset.read()*100);        //Espacios de decoracion e imprimo el porcentaje de PWM
        printf("          %d rpm\n",vuelta);                          //Espacios de decoracion e imprimo las rpm
        if (preset<0.1) {                                             //Si el valor del preset es menor al 10%, apago el motor
            motor=1;
        } else {                                                      //En caso contrario
            motor=1-preset.read();                                    //El motor es controlado por PWM por el preset.
            if (preset>0.95) {                                        //Y si la entrada es mayor al 95%, la velocidad del motor máxima
                motor=0;                                              //(Velocidad máxima)
            }
        }
    }
    if (modo==1) { //Cuando el modo es el de lazo cerrado
        probe.convertTemperature(false, DS1820::all_devices);         //Obtiene la temperatura y la almacena en probe.temperature
        temperatura = probe.temperature();                            //Guardo dicha temperatura en otra variable
        printf("%3.1f grados", probe.temperature());                  //Espacios de decoracion e imprimo la temperatura.
        printf("          %d rpm\n",vuelta);                          //Espacios de decoracion e imprimo las rpm.

        if (temperatura>=20 && temperatura<=70)                       //Si la temperatura es mayor a 20 y menor a 70, una cuenta determina la velocidad
            motor=1-((0.0178*temperatura)-0.246);                     //(Esta es la cuenta)

        if (temperatura<20)                                           //Cuando la temperatura es menor a 20, se apaga el motor
            motor=1;                                                  //Motor apagado

        if (temperatura>70)                                           //Si la temperatura es mayor a 70 grados
            motor=0;                                                  //El motor gira a la maxima velocidad
    }
    vuelta=0;                                                         //Reseteo la variable vueltas para que empiece a contar nuevamente
    pulsos=0;                                                         //Reseteo la variable pulsos para que empiece a contar nuevamente
}

//Se entra a esta funcion cada vez que el motor da media vuelta.
void velocidad()
{
    pulsos++; //Suma uno a la variable "pulsos" que luego va a ser dividida.

    if (modo==0) {
        if (preset<0.1) {                                             //Si el valor del preset es menor al 10%, apago el motor
            motor=1;
        } else {                                                      //En caso contrario
            motor=1-preset.read();                                    //El motor es controlado por PWM por el preset.
            if (preset>0.95) {                                        //Y si la entrada es mayor al 95%, la velocidad del motor máxima
                motor=0;                                              //(Velocidad máxima)
            }
        }
    }

    if (modo==1) {
        if (temperatura>=20 && temperatura<=70)                       //Si la temperatura es mayor a 20 y menor a 70, una cuenta determina la velocidad
            motor=1-((0.0178*temperatura)-0.246);                     //(Esta es la cuenta)

        if (temperatura<20)                                           //Cuando la temperatura es menor a 20, se apaga el motor
            motor=1;                                                  //Motor apagado

        if (temperatura>70)                                           //Si la temperatura es mayor a 70 grados
            motor=0;                                                  //El motor gira a la maxima velocidad
    }
}


