#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"

//Tsi...
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#else
  #error TARGET NOT DEFINED
#endif
//Aceleromtetro...
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

DigitalOut LR (LED_RED, 1);
DigitalOut LV (LED_GREEN, 1);
DigitalOut LA (LED_BLUE, 1);
DigitalIn  DIG(PTB1);
AnalogIn   AN (A0);

enum estados_Me_Inicio {LON, LOFF, HAB};
enum estados_Me_Inicio Inicio_Me_estado = LON;
enum estado_me_recepcion {ESPERO, INICIO, ORDEN, FIN};
enum estado_me_recepcion recepcion_me_estado = ESPERO;
enum estado_me_respuesta {RESPERA, RINICIO, RORDEN, ROX, ROY, ROZ, ROV, ROS1, ROS0, LRC, RFIN};
enum estado_me_respuesta respuesta_me_estado = RESPERA;

char   c = '\0', o = '\0';
unsigned char lrc = 0x0b;
bool newdata = false;
int t = 0, tr = 0, Vi = 0, Resp = 0;
int Xd, Xu, Yd, Yu, Zd, Zu, Vd, Vu, s = 0;
float Tsi = 0.0;

TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
Serial pc(USBTX, USBRX);
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

void Me_Inicio(void);
void cuenta(void);
void Me_Recepcion(void);
void Me_Respuesta(void);

void onCharReceived(){                                                          //Funcion en la que recibe el caracter...
    c = pc.getc();
    newdata = true;
    if(c >= 97 && c <= 122){
        c -= 32;
    }
}

void cuenta(){                                                                  //Funcion para el contador del programa...
    if (t != 0)
        t--;
    if(tr != 0)
        tr--;
    Tsi = tsi.readPercentage();
}

void datos(){
    
    
        
}

Ticker tiempo;

int main(void) {
    
    tiempo.attach(&cuenta, 0.01);
    pc.attach(&onCharReceived);
    
    while (true) {
        if(newdata){
            Me_Recepcion();
        }
        Me_Inicio();
        Me_Respuesta();
        datos();
    }
}


void Me_Inicio(){
    switch(Inicio_Me_estado){
        case LON:
            LR = 0;
            if(Tsi > 0)
                Inicio_Me_estado = HAB;
            if( Vi == 0 && t == 0){    
                t = 50;
                Inicio_Me_estado = LOFF;
            }
            if(Vi == 1 && t == 0){
                t = 25;
                Inicio_Me_estado = LOFF;
            }break;
        case LOFF:
            LR = 1;
            if(Tsi > 0)
                Inicio_Me_estado = HAB;
            if(Vi == 1 && t == 0){
                t = 15;
                Inicio_Me_estado = LON;
            }
            if(Vi == 0 && t == 0){
                t = 25;
                Inicio_Me_estado = LON;
            }break;
        case HAB:
            Vi = 1;
            if(t == 0){
                t = 25;
                Inicio_Me_estado = LON;
            }break;
        }
}

void Me_Recepcion(){
    switch(recepcion_me_estado){
        case ESPERO:
            if(c != 64 || Vi == 0){
                c = '\0';
                newdata = false;
            }
            if(c == 64){                                                        // @ = 64 en ASCII...
                recepcion_me_estado = INICIO;
                newdata = false;
            }
            break;
        case INICIO:
            if(c == 88 ||c == 89 ||c == 90 ||c == 86 ||c == 83){                //X = 88 ; y = 89 ; z = 90 ; v = 86 ; s = 83...
                recepcion_me_estado = ORDEN;
                o = c;
                newdata = false;
            }
            else{
                c = '\0';
                recepcion_me_estado = ESPERO;
                newdata = false;
            }break;
        case ORDEN: 
            if(c == 37){                                                        //% = 115
                recepcion_me_estado = FIN;
            }
            else{
                recepcion_me_estado = ESPERO;
                c = '\0';
                newdata = false;   
            }break;
        case FIN:
            recepcion_me_estado = ESPERO;
            Resp = 1;
            break;
    }
}

void Me_Respuesta(){
    switch(respuesta_me_estado){
        case RESPERA:
            lrc = 0x0;
            if(Resp == 1){
                tr = 1;
                respuesta_me_estado = RINICIO;
                pc.printf("%c",'@');
                lrc ^= 0x40;
            }break;
        case RINICIO:                                                   
            if(tr == 0){
                tr = 1;
                respuesta_me_estado = RORDEN;
                pc.printf("%c", o);
                lrc ^= o;
            }break;
        case RORDEN:
            if(o == 'X' && tr == 0){
                Xd = 10*abs(acc.getAccX());
                Xu = 10*abs(acc.getAccX()) - Xd;
                pc.printf("%d%d", Xd, Xu);
                lrc ^= (Xd + 48);
                lrc ^= (Xu + 48);
                tr = 1;
                respuesta_me_estado = LRC;
            }
            if(o == 'Y' && tr == 0){
                Yd = 10*abs(acc.getAccY());
                Yu = 10 *abs(acc.getAccX()) - Yd;
                pc.printf("%d%d", Yd, Yu);
                lrc ^= (Yd+48);
                lrc ^= (Yu+48);
                tr = 1;
                respuesta_me_estado = LRC;
            }
            if(o == 'Z' && tr == 0){
                Zd = 10*abs(acc.getAccZ());
                Zu = 10*abs(acc.getAccX()) - Zd;
                pc.printf("%d%d", Zd, Zu);
                lrc ^= (Zd+48);
                lrc ^= (Zu+48);
                tr = 1;
                respuesta_me_estado = LRC;
            }
            if(o == 'V' && tr == 0){
                Vd = AN.read()*3.3;
                Vu = AN.read()*33 - Vd*10;
                pc.printf("%d%d", Vd, Vu);
                lrc ^= (Vd+48);
                lrc ^= (Vu+48); 
                tr = 1;
                respuesta_me_estado = LRC;
            }
            if(o == 'S' && tr == 0){
                if(DIG == 1){
                    s = 49;
                }else{
                    s = 48;}
                pc.printf("%c", s);
                lrc ^= s ; 
                tr = 1;
                respuesta_me_estado = LRC;
            }break;
        case LRC:
            if(tr == 0){
                pc.printf("%X", lrc);
                respuesta_me_estado = RFIN;
                lrc = 0x0;
            }break;
        case RFIN: 
            if(tr == 0){
                pc.printf("%c\n",0x25);                                         // % = 0x25h = 37d
                Resp = 0;
                respuesta_me_estado = RESPERA;
            }break;
        }
}