#include <string.h>
#include "mbed.h"
 
Serial pc(USBTX, USBRX); // tx, rx
Serial serial6(PA_11, PA_12); // tx, rx
DigitalOut led1(LED1);

int ESP8266limitResponse = 999999;

char ESP8266responseOkStr[] = "OK\r\n";
char ESP8266responseGetStr[] = "OK\r\n> ";
char ESP8266responseReadyStr[] = "ready\r\n";
char ESP8266responseSendStr[] = "SEND OK\r\n\r\n";
char ESP8266responseClosedStr[] = "CLOSED\r\n";

char ESP8266initStr[] = "ROPE WIFI - TECHNOLOGY DAY";
char ESP8266doneStr[] = "done!";
char ESP8266resetStr[] = "Init ESP8266... ";
char ESP8266clientModeStr[] = "Client mode... ";
char ESP8266wifiConnectionStr[] = "WiFi connection... ";
char ESP8266serverConnectionStr[] = "Server connection... ";
char ESP8266sendingCharsStr[] = "Sending chars... ";
char ESP8266sendingRequestStr[] = "Sending request... ";

int ESP8266readResponse(char* delimiter) {
    int i = 0, j = 0;
    char c, exc;
    
    while(j<ESP8266limitResponse) {

        c = serial6.getc();
        pc.putc(c);
        
        if(c == delimiter[i]) {
            i++;
            
            if(delimiter[i] == '\0') {
                return (int) (exc-48);
            };
        } else {
            exc = c;
            i = 0;
        };
    };
    
    return 0;
};

void ESP8266init(char* ssid, char* password) {
    led1 = 1;
    
    pc.baud(115200);
    serial6.baud(115200);
    
    pc.printf("%s\r\n", ESP8266initStr);
    
    pc.printf("%s", ESP8266resetStr);
    serial6.printf("AT+RST\r\n");
    
    ESP8266readResponse(ESP8266responseOkStr);
    ESP8266readResponse(ESP8266responseReadyStr);
    pc.printf("%s\r\n", ESP8266doneStr);
    led1 = 0;
    pc.printf("%s", ESP8266clientModeStr);
    serial6.printf("AT+CWMODE=1\r\n");
    ESP8266readResponse(ESP8266responseOkStr);
    pc.printf("%s\r\n", ESP8266doneStr);
    
    pc.printf("%s", ESP8266wifiConnectionStr);
    serial6.printf("AT+CWJAP=\"%s\",\"%s\"\r\n", ssid, password);
    ESP8266readResponse(ESP8266responseOkStr);
    pc.printf("%s\r\n", ESP8266doneStr);
    
    led1 = 0;

};

int ESP8266get(char* domain, char* url) {
    int n1, n2;
    
    n1 = strlen(domain);
    n2 = strlen(url);
    
    pc.printf("%s", ESP8266serverConnectionStr);
    serial6.printf("AT+CIPSTART=\"TCP\",\"%s\",80\r\n", domain);
    ESP8266readResponse(ESP8266responseOkStr);
    pc.printf("%s\r\n", ESP8266doneStr);
    
    pc.printf("%s", ESP8266sendingCharsStr);
    serial6.printf("AT+CIPSEND=%d\r\n", 11+n1+1+n2+13);
    ESP8266readResponse(ESP8266responseGetStr);
    pc.printf("%s\r\n", ESP8266doneStr);
   
    pc.printf("%s", ESP8266sendingRequestStr);
    serial6.printf("GET http://%s/%s HTTP/1.0\r\n\r\n", domain, url);
    ESP8266readResponse(ESP8266responseSendStr);
    pc.printf("%s\r\n", ESP8266doneStr);
    
    return ESP8266readResponse(ESP8266responseClosedStr);
};

void init() {
    ESP8266init("Telecom-47520601", "famigliaquino2000router10");
};

void checkState() {
    int response;
    
    while(1) {
        char domain[] = "gabrieledisimone.it";
        char url[] = "neapolisRead.php";
        
        response = ESP8266get(domain, url);
        pc.printf("response:%d\r\n", response);
        
        switch(response) {
            case 1:
                
            break;
            
            case 2:
                
            break;
            
            case 3:
                
            break;
            
            case 4:
                
            break;
            
            default:
                
            break;
        };
        wait(3);
    };
};

int main() {   
    init();
    checkState();
};