#include <string.h>
#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
 
Serial pc(USBTX, USBRX); // tx, rx
Serial serial6(D1, D0); // tx, rx
DigitalOut led1(LED1);

int lineDisplay = 0;
int ESP8266limitResponse = 999999;

char ESP8266responseOkStr[] = "OK\r\n";
char ESP8266responseGetStr[] = "OK\r\n> ";
char ESP8266responseReadyStr[] = "ready\r\n";
char ESP8266responseSendStr[] = "SEND OK\r\n\r\n";
char ESP8266responseClosedStr[] = "CLOSED\r\n";

char ESP8266initStr[] = "ROPE WIFI - TECHNOLOGY DAY";
char ESP8266doneStr[] = "done!";
char ESP8266resetStr[] = "Init ESP8266... ";
char ESP8266clientModeStr[] = "Client mode... ";
char ESP8266wifiConnectionStr[] = "WiFi connection... ";
char ESP8266serverConnectionStr[] = "Server connection... ";
char ESP8266sendingCharsStr[] = "Sending chars... ";
char ESP8266sendingRequestStr[] = "Sending request... ";

TS_StateTypeDef TS_State;
uint8_t status;


void checkDisplayLines() {
    if(lineDisplay>7) {
        for(int idx = 2; idx<8; idx++) {
            lcd.ClearStringLine(idx);
        };
        
        lineDisplay = 2;
    };
};

bool ESP8266readResponse(char* delimiter, char* response) {
    int i = 0, j = 0;
    char c;
    
    while(j<ESP8266limitResponse) {
        c = serial6.getc();
        response[j++] = c;
        
        if(c == delimiter[i]) {
            i++;
            
            if(delimiter[i] == '\0') {
                response[j] = '\0';
                return true;
            };
        } else {
            i = 0;
        };
    };
    
    response[j] = '\0';
    return false;
};

void ESP8266init(char* ssid, char* password) {
    led1 = 0;
    lineDisplay = 0;
    
    pc.baud(115200);
    serial6.baud(115200);
    
    lcd.SetTextColor(LCD_COLOR_RED);
    pc.printf("%s\r\n", ESP8266initStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266initStr, CENTER_MODE);
    lineDisplay++;
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    pc.printf("%s", ESP8266resetStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266resetStr, LEFT_MODE);
    serial6.printf("AT+RST\r\n");
    ESP8266readResponse(ESP8266responseOkStr, NULL);
    ESP8266readResponse(ESP8266responseReadyStr, NULL);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    pc.printf("%s", ESP8266clientModeStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266clientModeStr, LEFT_MODE);
    serial6.printf("AT+CWMODE=1\r\n");
    ESP8266readResponse(ESP8266responseOkStr, NULL);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    pc.printf("%s", ESP8266wifiConnectionStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266wifiConnectionStr, LEFT_MODE);
    serial6.printf("AT+CWJAP=\"%s\",\"%s\"\r\n", ssid, password);
    ESP8266readResponse(ESP8266responseOkStr, NULL);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    led1 = 1;
    lcd.SetTextColor(LCD_COLOR_BLUE); //request button
    lcd.FillCircle(425, 230, 25);
    
    lcd.SetTextColor(LCD_COLOR_RED); //request button
    lcd.FillCircle(350, 230, 25);
    
    lcd.SetTextColor(LCD_COLOR_YELLOW); //request button
    lcd.FillCircle(275, 230, 25);
    
    lcd.SetTextColor(LCD_COLOR_GREEN); //request button
    lcd.FillCircle(200, 230, 25);
    
    lcd.SetTextColor(LCD_COLOR_BLACK); 
};

void ESP8266get(char* domain, char* url, char* response) {
    int n1, n2;
    
    n1 = strlen(domain);
    n2 = strlen(url);
    
    pc.printf("%s", ESP8266serverConnectionStr);
    checkDisplayLines();
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266serverConnectionStr, LEFT_MODE);
    serial6.printf("AT+CIPSTART=\"TCP\",\"%s\",80\r\n", domain);
    ESP8266readResponse(ESP8266responseOkStr, NULL);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    pc.printf("%s", ESP8266sendingCharsStr);
    checkDisplayLines();
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266sendingCharsStr, LEFT_MODE);
    serial6.printf("AT+CIPSEND=%d\r\n", 11+n1+1+n2+13);
    ESP8266readResponse(ESP8266responseGetStr, NULL);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    
    pc.printf("%s", ESP8266sendingRequestStr);
    checkDisplayLines();
    lcd.DisplayStringAt(0, LINE(lineDisplay), (uint8_t *)ESP8266sendingRequestStr, LEFT_MODE);
    serial6.printf("GET http://%s/%s HTTP/1.0\r\n\r\n", domain, url);
    ESP8266readResponse(ESP8266responseSendStr, NULL);
    ESP8266readResponse(ESP8266responseClosedStr, response);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    pc.printf("%s\r\n", ESP8266doneStr);
    lcd.DisplayStringAt(0, LINE(lineDisplay++), (uint8_t *)ESP8266doneStr, RIGHT_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
};

void LCDinit() {
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    
    lcd.SetTextColor(LCD_COLOR_BLACK); //reset button
    lcd.FillCircle(50, 230, 25);
};

void init() {
    LCDinit();
    ESP8266init("Telecom-47520601", "famigliaquino2000router10");
};

void TSdetect() {
    while(1) {
        int idx, x, y;
        ts.GetState(&TS_State); //TOUCH STATE
        
        if (TS_State.touchDetected) {  //TOUCH DETECTED
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                
                if ((x>400)&&(x<450)&&(y>205)&&(y<255)) {  
                    char response[ESP8266limitResponse];
                    char domain[] = "gabrieledisimone.it";
                    char url[] = "neapolis.php?button=4";
                    
                    ESP8266get(domain, url, response);
                    pc.printf("response:\r\n%s", response);
                } else if ((x>325)&&(x<375)&&(y>205)&&(y<255)) {  
                    char response[ESP8266limitResponse];
                    char domain[] = "gabrieledisimone.it";
                    char url[] = "neapolis.php?button=3";
                    
                    ESP8266get(domain, url, response);
                    pc.printf("response:\r\n%s", response);
                } else if ((x>250)&&(x<300)&&(y>205)&&(y<255)) {  
                    char response[ESP8266limitResponse];
                    char domain[] = "gabrieledisimone.it";
                    char url[] = "neapolis.php?button=2";
                    
                    ESP8266get(domain, url, response);
                    pc.printf("response:\r\n%s", response);
                } else if ((x>175)&&(x<225)&&(y>205)&&(y<255)) {  
                    char response[ESP8266limitResponse];
                    char domain[] = "gabrieledisimone.it";
                    char url[] = "neapolis.php?button=1";
                    
                    ESP8266get(domain, url, response);
                    pc.printf("response:\r\n%s", response);
                } else if ((x>25)&&(x<75)&&(y>205)&&(y<255)) {
                    init();
                };
            };
        };
    };
};

int main() {    
    init();
    TSdetect();
};