/*******************************************************************************
 * Copyright (c) 2014-2015 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Zurich Research Lab - initial API, implementation and documentation
 * /////////////////////////////////////////////////////////////////////////////
 *
 * Used by Giorgos Tsapparellas for Internet of Things (IoT) smart monitoring
 * device for agriculture using LoRaWAN technology.
 * 
 * Date of issued copy: 25 January 2018
 *
 * Modifications: 
 * - No external modifications of the existing "AS IT IS" software.
 * - Added some external comments for meeting good principles of 
 *   source code re-usability.   
 ******************************************************************************/

#ifndef _hal_hpp_
#define _hal_hpp_

/* 
 * hal_init function of type void.
 *
 * Initializes hardware (IO, SPI, TIMER, IRQ).
 *
 * Input parameters: None
 *
 */ 
void hal_init (void);

/* 
 * hal_pin_nss function of type void.
 *
 * Drives radio NSS pin (0=low, 1=high).
 *
 * Input parameters: unsigned int val
 *
 */ 
void hal_pin_nss (u1_t val);

/* 
 * hal_pin_rxtx function of type void.
 *
 * Drives radio RX/TX pins (0=rx, 1=tx).
 *
 * Input parameters: unsigned int val
 *
 */ 
void hal_pin_rxtx (u1_t val);

/* 
 * hal_pin_rst function of type void.
 *
 * Controls radio RST pin (0=low, 1=high, 2=floating).
 *
 * Input parameters: unsigned int val
 *
 */ 
void hal_pin_rst (u1_t val);

/* 
 * hal_spi function of type unsigned integer.
 *
 * Performs 8-bit SPI transaction with radio.
 *   - write given byte 'outval'
 *   - read byte
 *
 * Input parameters: unsigned int outval
 * Return: value
 *
 */ 
u1_t hal_spi (u1_t outval);

/* 
 * hal_disableIRQs function of type void.
 *
 * Disables all CPU interrupts.
 *   - might be invoked nested 
 *   - will be followed by matching call to hal_enableIRQs()
 *
 * Input parameters: None
 *
 */ 
void hal_disableIRQs (void);

/* 
 * hal_enableIRQs function of type void.
 *
 * Enables CPU interrupts.
 *
 * Input parameters: None
 *
 */ 
void hal_enableIRQs (void);

/* 
 * hal_sleep function of type void.
 *
 * Puts system and CPU in low-power mode, sleep until interrupt.
 *
 * Input parameters: None
 *
 */ 
void hal_sleep (void);

/* 
 * hal_ticks function of type unsigned interger.
 *
 * Input parameters: None
 * Return: 32-bit system time in ticks.
 */ 
u4_t hal_ticks (void);

/* 
 * hal_waitUntil function of type void.
 *
 * Busy-wait until specified timestamp (in ticks) is reached.
 *
 * Input parameters: unsigned int time
 */ 
void hal_waitUntil (u4_t time);

/* 
 * hal_checkTimer function of type unsigned char.
 *
 * Checks and rewinds timer for target time.
 *
 * Input parameters: unsigned int targettime
 * Return: - 1 if target time is close
 *         - otherwise rewind timer for target time or full period and return 0 
 */ 
u1_t hal_checkTimer (u4_t targettime);

/* 
 * hal_failed function of type void.
 *
 * Performs fatal failure action.
 *   - called by assertions
 *   - action could be HALT or reboot
 *
 * Input parameters: None
 *
 */ 
void hal_failed (void);

#endif // _hal_hpp_
