#include "mbed.h"
#include "MMiniFileReader.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "MBedStation.h"
#include "sensor_base.h"
#include "Coms.h"
 
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
Serial pc(USBTX, USBRX);
iniFile iniconfig;
char * ComsType;
DigitalOut light1(LED1);
DigitalOut light3(LED3);
DigitalOut Red(p8);
PwmOut Green(p21);
EthernetInterface ethtmp;
TCPSocketConnection socktmp;
Coms MMComs;
int connected = 0;
int datasendtime;
char datasample[250];
char * datasample1;
char * datasample2;
char * datasample3;
char * datasample4;

MBedStation MBed1;

sensor_pulse SensorTest(p6);
    
int main() 
{    
    int error;
    Red=1;
    light3=1;
    Green.period(0.2);
    Green=0;
    light1=0;
        
    MBed1.setup();
    
    
    sensor_onoff* sensor0;
    sensor0 = &MBed1.sensor_0;

    sensor_vin* sensor1;
    sensor1 = &MBed1.sensor_1;

    sensor_vin* sensor2;
    sensor2 = &MBed1.sensor_2;

    sensor_pulse SensorTest(p6);
    SensorTest.sensor_id = 2;
    SensorTest.enabled = true;
    //sensor_pulse* sensor3;
    //sensor3->IntIn.rise(sensor3, &sensor_pulse::ISR1);
    //sensor3 = &MBed1.sensor_3;

    //Ini file reading
    iniFileReader filereader;
    
    iniconfig = filereader.ReadFile("/local/ini.txt");

    ComsType=iniconfig.Station.ComsType;
    
    pc.printf("IPAddress=%s",iniconfig.Station.IPAddress);
    pc.printf("Coms Type=%s",ComsType);
    datasendtime = atoi(iniconfig.Station.DataSendTime);
    pc.printf("datasendtime=%i\r\n",datasendtime); 

    while (true) { //Main Program Loop - allows for re-establishing coms

        //int retrys = 5;       
    
        // /* Ethernet connection
         if (strncmp(ComsType,"Ethernet",8)==0) {
            printf("\r\n");   
            printf("Initialising ethernet...\r\n");
        
            error = MMComs.EthernetInitialise(iniconfig.Station.IPAddress, iniconfig.Station.NetworkMask, iniconfig.Station.DefaultGateway);
        
            if (error)  {
                printf("Error: Could not initialise ethernet (code %i)...\r\n", error);
                while(true);
            }
            printf("MAC Address is %s\r\n", MMComs.getMACAddress());
            printf("Obtaining IP address...\r\n");
            
            error = MMComs.EthernetConnect();
            if (error) {
                printf("Error: Could not obtain IP address (code %i) \r\n", error);
                while(true);
            }
            
            printf("IP Address is %s\r\n", ethtmp.getIPAddress());
            printf("Network Mask is %s\r\n", ethtmp.getNetworkMask());
            printf("Default Gateway is %s\r\n", ethtmp.getGateway());  
            printf("Connecting...\r\n");
        
        }
        else {
            printf("ethernet not required...\r\n");
        }
        
        //retrys = 5;

       // End of Ethernet connection



        //retrys = 0;
    
        printf("Monitoring \r\n");
        Green=0.01;
        light1=1;
    
        //Start of Monitoring Loop
        while (true)
        {
            Red=0;
            light3=0;
            datasample1 = sensor0->read_data();
            datasample2 = sensor1->read_data();
            datasample3 = sensor2->read_data();
            //datasample4 = sensor3->read_data();
            //sensor3->reset();
            datasample4 = SensorTest.read_data();
            SensorTest.reset();
            //printf("Testr: %s\n", datasample4);
               
            sprintf(datasample,"<<1%s,%s>>\n",datasample1,datasample4);
            //sprintf(datasample,"<<1%s,%s,%s>>\n",datasample1,datasample2,datasample3);
            printf(datasample);  
        
            if (strncmp(ComsType,"Ethernet",8)==0) {
                printf("Trying to Connect to %s Port: %s \r\n",iniconfig.Server.IPAddress,iniconfig.Server.Port);
                
                Red=1;
                light3=1;
                
                error = MMComs.EthernetSocketConnect(iniconfig.Server.IPAddress, atoi(iniconfig.Server.Port));            
                if (error) {
                    printf("Connect Failed\r\n");
                    continue;
                    //break;
                }
                
                error = MMComs.EthernetSocketSendAll(datasample, sizeof(datasample)-1);
                if (error) {
                    printf("Send Failed\r\n");
                    //continue;
                    //break;
                }
                else {
                    Red=0;                    
                    light3=0;
                    
                    char buffer[300];
                    ////////////////start of receiving status
                    int ret;
                    while (true) {
                        ret = MMComs.EthernetSocketReceive(buffer, sizeof(buffer)-1);
                        //ret = sock.receive(buffer, sizeof(buffer)-1);
                        if (ret <= 0) break;
                        buffer[ret] = '\0';
                        MBed1.ProcessResponse(buffer);
                        printf("%d",atoi(buffer));
                        printf("Received %d chars from server:\r\n%s\r\n", ret, buffer);
                    }
                    
                }
                MMComs.EthernetSocketClose();            
 
            }
        
            
            Thread::wait(datasendtime);
      
        } // End of Monitoring Loop

    } //End of Main Programme Loop
    
    //eth.disconnect();
            
}

