#pragma once
#include "mbed.h"
#include "qeihw.h"
#include "QEIx4.h"
#include <cstdint>



class sensor_base
{
public:
    sensor_base();
    ~sensor_base();
    int sensor_id;
    int sensor_type;
    char data_sample[50];
    virtual char * read_data();
    bool enabled;
};


class sensor_onoff : public sensor_base
{
public:
    //sensor_base();
    sensor_onoff();
    sensor_onoff(PinName);
    ~sensor_onoff();
    DigitalIn din;
    virtual char * read_data();
    char data_sample[50];
};


class sensor_vin : public sensor_base
{
public:
    sensor_vin();
    sensor_vin(PinName);
    ~sensor_vin();
    AnalogIn ain;
    virtual char * read_data();
    char data_sample[50];
};

class sensor_pulse : public sensor_base
{
public:
    sensor_pulse();
    sensor_pulse(PinName);
    ~sensor_pulse();
    void ISR1();
    void reset();
    float frequency;    
    float uptime;
    float firstpulsetime;
    float lastpulsetime;
    float elapsedtime;
    virtual char * read_data();
    char data_sample[50];
    InterruptIn IntIn;
    int pulsecount;
private:        
    Timer t;
    float period;
};

/*
class sensor_pulse : public sensor_base
{
public:
    sensor_pulse();
    sensor_pulse(PinName);
    ~sensor_pulse();
    AnalogIn IntIn;
    //void ISR1();
    //int pulsecount;
    //float uptime;
    //float firstpulsetime;
    //float lastpulsetime;
    virtual char * read_data();
    char data_sample[50];  
//private:
    //InterruptIn IntIn;
};

*/

class sensor_qeihw : public sensor_base
{
public:
    sensor_qeihw();
    ~sensor_qeihw();
    QEIHW qei;
    virtual char * read_data();
    char data_sample[50];
};

class sensor_qeix4 : public sensor_base
{
public:
    sensor_qeix4();
    ~sensor_qeix4();
    QEIx4 qei;
    void poll();
    virtual char * read_data();
    char data_sample[50];
};

class sensor_max6675 //: public sensor_base
{
    SPI spi;
    DigitalOut ncs;
        
public:

    int sensor_id;
    int sensor_type;
    bool enabled;
    
    //sensor_max6675();
    //sensor_max6675(PinName _cs, PinName _so, PinName _sck, PinName _ncs);
    sensor_max6675(SPI _spi, PinName _ncs);
    ~sensor_max6675();
    void select();
    void deselect();    
    float read_temp();
    
    virtual char * read_data();
    char data_sample[50];

  private:
    //PinName _CS_pin;
    //PinName _SO_pin;
    //PinName _SCK_pin;
    int _units;
    float _error;
    
};

/*
class Counter {
public:
    Counter(PinName pin);
    void increment();
    int read(); 
private:
    InterruptIn _interrupt;
    volatile int _count;
};

*/
