#include "mbed.h"
#include <stdio.h>
#include "sensor_base.h"
#include <iostream> 
#include "qeihw.h"

using namespace std;



sensor_base::sensor_base()
{
    sensor_id = 0;
}

/*
sensor_base::sensor_base(int id)
{
    sensor_id = id;
}
*/

char * sensor_base::read_data()
{
    //char  mretval[50];
    sprintf(data_sample, "[ID:%d;%5.3f]", sensor_id, 1.0);
    return "Base";
    //mretval[0] = 68;
}

sensor_base::~sensor_base()
{
}

///////////////////////////////// Digital sensor starts here //////////////////////////////////////


sensor_onoff::sensor_onoff() :din(p22)
{

}



sensor_onoff::sensor_onoff(PinName pin) :din(pin)
{

}


char * sensor_onoff::read_data()
{
    //char  mretval[50];
    //sprintf(data_sample, "\r\nOnOff[%d]=%d", sensor_id,din.read());
    sprintf(data_sample, "[%d;%d]", sensor_id, din.read());
    return data_sample;
    //mretval[0] = 68;
}


sensor_onoff::~sensor_onoff()
{
}

/////////////////////////////////Start of sensor_vin/////////////////////////////////

sensor_vin::sensor_vin() :ain(p15) {
}

sensor_vin::sensor_vin(PinName pin) :ain(pin) {
    Serial pc(USBTX, USBRX);    
}

char * sensor_vin::read_data()
{
    //char  mretval[50];
    sprintf(data_sample, "[%d;%f]", sensor_id, ain.read());
    return data_sample;
    //mretval[0] = 68;
}

sensor_vin::~sensor_vin() {
}


///////////////////////////////////////// Start of sensor_pulse ///////////////

sensor_pulse::sensor_pulse() :IntIn(p16) {
}

sensor_pulse::sensor_pulse(PinName pin) :IntIn(pin) {
    IntIn.rise(this, &sensor_pulse::ISR1);
}

char * sensor_pulse::read_data()
{
    elapsedtime = t.read();
    if (pulsecount>=2) {
        period=(lastpulsetime-firstpulsetime)/(pulsecount-1);
        uptime = (lastpulsetime-firstpulsetime);        
        if ((firstpulsetime < period) and (elapsedtime - lastpulsetime) < period) {
            uptime = elapsedtime;
        }
        frequency=1/period;
    }
    else {
        uptime=0;
        frequency=0;
    }
    //sprintf(data_sample, "[%d;%f;%f;%d;%f;%f;%f]", sensor_id, frequency, uptime ,pulsecount, firstpulsetime, lastpulsetime, elapsedtime);
    sprintf(data_sample, "[%d;%d;%f]", sensor_id, pulsecount, uptime);
    
    pulsecount ++;    
    return data_sample;
    
}

sensor_pulse::~sensor_pulse() {
}

void sensor_pulse::reset() {
    t.reset();
    t.start();
    firstpulsetime=0;
    lastpulsetime=0;
    pulsecount=0;
}


void sensor_pulse::ISR1() {
    if (pulsecount==0) {
        firstpulsetime=t.read();
    }
    lastpulsetime=t.read();
    pulsecount ++;
    //sensor_id ++;   
    //DigitalOut light3(LED3);
    //light3=1;
}


////////////////////////// quadrature encoder HW /////////////////////////////////////////////

void toggleIndexLed(void) {
    //  led3 = !led3;
}

sensor_qeihw::sensor_qeihw()  : qei(QEI_DIRINV_NONE, QEI_SIGNALMODE_QUAD, QEI_CAPMODE_4X, QEI_INVINX_NONE)
{
    qei.SetDigiFilter(480UL);
    qei.SetMaxPosition(1000000);
    qei.SetVelocityTimerReload_us(1000);
    qei.AppendISR(QEI_INTFLAG_INX_Int, &toggleIndexLed);

    qei.IntCmd(QEI_INTFLAG_INX_Int, ENABLE);
    //sensor_id=1001;
    sensor_id=1001;
}


char * sensor_qeihw::read_data()
{
    //char  mretval[50];
    sprintf(data_sample, "[ID:%d;%d;%d;%d]", sensor_id, qei.GetPosition(), qei.GetVelocityCap(), qei.GetIndex());
    return data_sample;
    //mretval[0] = 68;
}


sensor_qeihw::~sensor_qeihw()
{
}


////////////////////////////////////// Quadrature standard ///////////////////////////


// The callback functions
void myCounterChangeCallback(int value)
{
    static int valueLast=-1;

    if ( value > valueLast ) {
        //LEDup = !LEDup;
        //LEDdown = 0;
    } else {
        //LEDdown = !LEDdown;
        //LEDup = 0;
    }
    valueLast = value;
}

void myIndexTriggerCallback(int value)
{
    //qei = 0;   // reset counter
    //LEDzero = 1;
}

sensor_qeix4::sensor_qeix4()  : qei(p24, p25, NC,  QEIx4::POLLING)
{
QEIx4 qei(p24, p25, NC,  QEIx4::POLLING); 
qei.attachIndexTrigger(myIndexTriggerCallback);    
qei.attachCounterChange(myCounterChangeCallback);
sensor_id=1003;
}

char * sensor_qeix4::read_data()
{
    //char  mretval[50];
    //sprintf(data_sample, "[%d;%5.3f]\n", (int)qei, 1.0);
    //sprintf(data_sample,"\r\nQEI=%d", (int)qei);
    sprintf(data_sample, "[ID:%d;%d;%5.3f]", sensor_id, (int)qei,0.0);
    return data_sample;
    //mretval[0] = 68;
}

void sensor_qeix4::poll()
{
    qei.poll();
}    

sensor_qeix4::~sensor_qeix4()
{
}

///////////////////////////////////////// Start of sensor_max6675 ///////////////

//sensor_max6675::sensor_max6675()  : spi(p11,p12,p13), ncs(p18) {
//}

sensor_max6675::sensor_max6675(SPI _spi, PinName _ncs) : spi(_spi), ncs(_ncs) {
//sensor_max6675::sensor_max6675(PinName _cs, PinName _so, PinName _sck, PinName _ncs) : spi(_cs, _so, _sck), ncs(_ncs) {

}

sensor_max6675::~sensor_max6675()
{
}

char * sensor_max6675::read_data()
{
    //char  mretval[50];
    sprintf(data_sample, "[%d;%f]", sensor_id, read_temp());
    return data_sample;
    //mretval[0] = 68;
}

float sensor_max6675::read_temp() {
    short value = 0;
    float temp = 0;
    
    uint8_t highByte=0;
    uint8_t lowByte=0;
    
    select();
    wait(.25); //This delay is needed else it does'nt seem to update the temp

    highByte = spi.write(0);
    lowByte = spi.write(0);
    deselect();


    if (lowByte & (1<<2)) {
        error("No Probe");
    } else {
        value = (highByte << 5 | lowByte>>3);
    }

    temp = (value*0.25); // Multiply the value by 0.25 to get temp in ˚C or
                         //  * (9.0/5.0)) + 32.0;   // Convert value to ˚F (ensure proper floats!)

return temp;
}

void sensor_max6675::select() {
    ncs = 0;
}

void sensor_max6675::deselect() {
    ncs = 1;
}


/*
class Counter {
public:
    Counter(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &Counter::increment); // attach increment function of this counter instance
    }
 
    void increment() {
        _count++;
    }
 
    int read() {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};


    Counter::Counter(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &Counter::increment); // attach increment function of this counter instance
    }
 
    void Counter::increment() {
        _count++;
    }
 
    int Counter::read() {
        return _count;
    }
*/