/*

Because a member function is meaningless without an object to invoke it on, you can’t do this directly (if The X Window System was rewritten in C++, it would probably pass references to objects around, not just pointers to functions; naturally the objects would embody the required function and probably a whole lot more).

As a patch for existing software, use a top-level (non-member) function as a wrapper which takes an object obtained through some other technique. Depending on the routine you’re calling, this “other technique” might be trivial or might require a little work on your part. The system call that starts a thread, for example, might require you to pass a function pointer along with a void*, so you can pass the object pointer in the void*. Many real-time operating systems do something similar for the function that starts a new task. Worst case you could store the object pointer in a global variable; this might be required for Unix signal handlers (but globals are, in general, undesired). In any case, the top-level function would call the desired member function on the object.

Here’s an example of the worst case (using a global). Suppose you want to call Fred::memberFn() on interrupt:

class Fred {
public:
  void memberFn();
  static void staticMemberFn();  // A static member function can usually handle it
  // ...
};
// Wrapper function uses a global to remember the object:
Fred* object_which_will_handle_signal;
void Fred_memberFn_wrapper()
{
  object_which_will_handle_signal->memberFn();
}
int main()
{
  signal(SIGINT, Fred::memberFn);    // Can NOT do this
  signal(SIGINT, Fred_memberFn_wrapper);  // Okay
  signal(SIGINT, Fred::staticMemberFn);   // Okay usually; see below
  }
Note: static member functions do not require an actual object to be invoked, so pointers-to-static-member-functions are usually type-compatible with regular pointers-to-functions. However, although it probably works on most compilers, it actually would have to be an extern "C" non-member function to be correct, since “C linkage” doesn’t only cover things like name mangling, but also calling conventions, which might be different between C and C++.

Test
*/